/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.view;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.radiowaves.EmfConfig;
import edu.colorado.phet.radiowaves.EmfModule;
import edu.colorado.phet.radiowaves.RadioWavesResources;
import edu.colorado.phet.radiowaves.command.DynamicFieldIsEnabledCmd;
import edu.colorado.phet.radiowaves.command.SetAmplitudeCmd;
import edu.colorado.phet.radiowaves.command.SetFreqencyCmd;
import edu.colorado.phet.radiowaves.command.StaticFieldIsEnabledCmd;
import edu.colorado.phet.radiowaves.coreadditions.MessageFormatter;
import edu.colorado.phet.radiowaves.model.EmfModel;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EmfControlPanel
extends ControlPanel {
    private EmfModel model;
    private EmfModule module;

    public EmfControlPanel(EmfModel emfModel, EmfModule emfModule) {
        this.model = emfModel;
        this.module = emfModule;
        this.addControlFullWidth(new Legend());
        this.addControlFullWidth(new MovementControlPane());
        this.addControlFullWidth(new OptionControlPane());
    }

    private class Legend
    extends JPanel {
        Legend() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(RadioWavesResources.getString("EmfControlPanel.LegendBorder")));
            ImageIcon imageIcon = null;
            try {
                imageIcon = new ImageIcon(ImageLoader.loadBufferedImage("radio-waves/images/blue-sml.gif"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            int n = 0;
            try {
                SwingUtils.addGridBagComponent(this, new JLabel(RadioWavesResources.getString("EmfControlPanel.ElectronLabel"), imageIcon, 2), 0, n++, 1, 1, 2, 17);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
        }
    }

    private class MovementControlPane
    extends JPanel {
        JRadioButton sineRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.OscillateRadioButton"));
        JRadioButton manualRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.ManualRadioButton"));
        JCheckBox coordinateFACB = new JCheckBox(MessageFormatter.format(RadioWavesResources.getString("EmfControlPanel.CoordinateFACheckBox")));
        ButtonGroup rbGroup = new ButtonGroup();
        int maxFreq = 200;
        JSlider freqSlider = new JSlider(0, this.maxFreq, this.maxFreq / 2);
        int maxAmplitude = 100;
        JSlider ampSlider = new JSlider(0, this.maxAmplitude, this.maxAmplitude / 2);
        private boolean coordinateFandA;
        private JLabel freqLabel;
        private JLabel ampLabel;

        MovementControlPane() {
            this.setLayout(new GridBagLayout());
            this.rbGroup.add(this.sineRB);
            this.rbGroup.add(this.manualRB);
            EtchedBorder etchedBorder = (EtchedBorder)BorderFactory.createEtchedBorder();
            this.setBorder(etchedBorder);
            this.setBorder(BorderFactory.createTitledBorder(RadioWavesResources.getString("EmfControlPanel.TransmitterMovementBorder")));
            this.sineRB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MovementControlPane.this.setMovementType();
                }
            });
            this.manualRB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MovementControlPane.this.setMovementType();
                }
            });
            this.freqSlider.setPaintTicks(true);
            this.freqSlider.setPreferredSize(new Dimension(120, (int)this.freqSlider.getPreferredSize().getHeight()));
            this.freqSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    new SetFreqencyCmd(EmfControlPanel.this.model, (float)MovementControlPane.this.freqSlider.getValue() / 5000.0f).doIt();
                    if (MovementControlPane.this.coordinateFandA) {
                        double d = 1.0 - (double)MovementControlPane.this.freqSlider.getValue() / (double)MovementControlPane.this.freqSlider.getMaximum();
                        MovementControlPane.this.ampSlider.setValue((int)((double)MovementControlPane.this.maxAmplitude * d));
                    }
                }
            });
            this.ampSlider.setPaintTicks(true);
            this.ampSlider.setPreferredSize(new Dimension(120, (int)this.ampSlider.getPreferredSize().getHeight()));
            this.ampSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    new SetAmplitudeCmd(EmfControlPanel.this.model, MovementControlPane.this.ampSlider.getValue()).doIt();
                }
            });
            new SetAmplitudeCmd(EmfControlPanel.this.model, this.ampSlider.getValue()).doIt();
            this.coordinateFACB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MovementControlPane.this.setCoordinateFandA(MovementControlPane.this.coordinateFACB.isSelected());
                }
            });
            this.coordinateFACB.setSelected(false);
            this.setCoordinateFandA(this.coordinateFACB.isSelected());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 32, 0, 0), 0, 0);
            this.add((Component)this.manualRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add((Component)this.sineRB, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ++gridBagConstraints.gridy;
            this.freqLabel = new JLabel(RadioWavesResources.getString("EmfControlPanel.FrequencyLabel"));
            this.add((Component)this.freqLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add((Component)this.freqSlider, gridBagConstraints);
            this.ampLabel = new JLabel(RadioWavesResources.getString("EmfControlPanel.AmplitudeLabel"));
            ++gridBagConstraints.gridy;
            this.add((Component)this.ampLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add((Component)this.ampSlider, gridBagConstraints);
            this.manualRB.setSelected(true);
            this.setMovementType();
        }

        void setCoordinateFandA(boolean bl) {
            this.coordinateFandA = bl;
        }

        void setMovementType() {
            if (this.manualRB.isSelected()) {
                EmfControlPanel.this.module.setMovementManual();
            }
            if (this.sineRB.isSelected()) {
                EmfControlPanel.this.module.setMovementSinusoidal();
            }
            EmfControlPanel.this.module.recenterElectrons();
            EmfControlPanel.this.module.setAutoscaleEnabled(false);
            this.freqLabel.setEnabled(this.sineRB.isSelected());
            this.ampLabel.setEnabled(this.sineRB.isSelected());
            this.freqSlider.setEnabled(this.sineRB.isSelected());
            this.ampSlider.setEnabled(this.sineRB.isSelected());
        }
    }

    private class OptionControlPane
    extends JPanel {
        private JCheckBox stripChartCB = new JCheckBox(RadioWavesResources.getString("EmfControlPanel.StripChartCheckBox"));
        private JRadioButton staticFieldRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.StaticFieldRadioButton"));
        private JRadioButton dynamicFieldRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.RadiatedFieldRadioButton"));
        private JRadioButton fullFieldRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.FullRadioButton"));
        private JRadioButton hideFieldRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.NoneRadioButton"));
        private ButtonGroup fieldDisplayRBGroup;
        private JRadioButton vectorWCurveRB;
        private JRadioButton curveRB;

        OptionControlPane() {
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.dynamicFieldRB);
            buttonGroup.add(this.staticFieldRB);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0);
            jPanel.setBorder(BorderFactory.createTitledBorder(RadioWavesResources.getString("EmfControlPanel.FieldVectorBorder")));
            jPanel.add((Component)this.dynamicFieldRB, gridBagConstraints);
            jPanel.add((Component)this.staticFieldRB, gridBagConstraints);
            this.staticFieldRB.addActionListener(new FieldViewRBActionListener());
            this.dynamicFieldRB.addActionListener(new FieldViewRBActionListener());
            this.hideFieldRB.addActionListener(new FieldViewRBActionListener());
            this.hideFieldRB.addActionListener(new FieldViewRBActionListener());
            this.fullFieldRB.addActionListener(new FieldViewRBActionListener());
            this.vectorWCurveRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.CurveVectorsRadioButton"));
            this.vectorWCurveRB.addActionListener(new FieldViewRBActionListener());
            this.curveRB = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.CurveRadioButton"));
            this.curveRB.addActionListener(new FieldViewRBActionListener());
            this.fieldDisplayRBGroup = new ButtonGroup();
            this.fieldDisplayRBGroup.add(this.curveRB);
            this.fieldDisplayRBGroup.add(this.vectorWCurveRB);
            this.fieldDisplayRBGroup.add(this.fullFieldRB);
            this.fieldDisplayRBGroup.add(this.hideFieldRB);
            this.curveRB.setSelected(true);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0);
            jPanel2.setBorder(BorderFactory.createTitledBorder(RadioWavesResources.getString("EmfControlPanel.FieldDisplayBorder")));
            jPanel2.add((Component)this.vectorWCurveRB, gridBagConstraints2);
            jPanel2.add((Component)this.curveRB, gridBagConstraints2);
            jPanel2.add((Component)this.fullFieldRB, gridBagConstraints2);
            jPanel2.add((Component)this.hideFieldRB, gridBagConstraints2);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0);
            JRadioButton jRadioButton = new JRadioButton(MessageFormatter.format(RadioWavesResources.getString("EmfControlPanel.ForceFieldRadioButton")));
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EmfControlPanel.this.module.setFieldSense(1);
                }
            });
            buttonGroup2.add(jRadioButton);
            jPanel3.add((Component)jRadioButton, gridBagConstraints3);
            JRadioButton jRadioButton2 = new JRadioButton(RadioWavesResources.getString("EmfControlPanel.ElectricFieldRadioButton"));
            jRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EmfControlPanel.this.module.setFieldSense(-1);
                }
            });
            buttonGroup2.add(jRadioButton2);
            jPanel3.add((Component)jRadioButton2, gridBagConstraints3);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(RadioWavesResources.getString("EmfControlPanel.FieldSenseBorder"));
            jPanel3.setBorder(titledBorder);
            this.stripChartCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialog jDialog = EmfControlPanel.this.module.setStripChartEnabled(OptionControlPane.this.stripChartCB.isSelected());
                    jDialog.addComponentListener(new ComponentAdapter(){

                        public void componentHidden(ComponentEvent componentEvent) {
                            OptionControlPane.this.stripChartCB.setSelected(false);
                        }
                    });
                }
            });
            JButton jButton = new JButton(RadioWavesResources.getString("EmfControlPanel.RecenterButton"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EmfControlPanel.this.module.recenterElectrons();
                }
            });
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)jPanel, gridBagConstraints4);
            this.add((Component)jPanel2, gridBagConstraints4);
            this.add((Component)jPanel3, gridBagConstraints4);
            this.add((Component)jPanel, gridBagConstraints4);
            gridBagConstraints4.insets = new Insets(4, 15, 0, 0);
            this.add((Component)this.stripChartCB, gridBagConstraints4);
            this.vectorWCurveRB.setSelected(true);
            this.dynamicFieldRB.setSelected(true);
            jRadioButton.setSelected(true);
            this.setFieldView();
        }

        private void setFieldView() {
            EmfControlPanel.this.module.displayStaticField(this.staticFieldRB.isSelected());
            EmfControlPanel.this.module.displayDynamicField(this.dynamicFieldRB.isSelected());
            new StaticFieldIsEnabledCmd(EmfControlPanel.this.model, true).doIt();
            new DynamicFieldIsEnabledCmd(EmfControlPanel.this.model, true).doIt();
            boolean bl = false;
            if (this.staticFieldRB.isSelected()) {
                bl = false;
                this.fullFieldRB.setSelected(true);
            } else if (this.dynamicFieldRB.isSelected()) {
                bl = true;
            }
            this.hideFieldRB.setEnabled(bl);
            this.curveRB.setEnabled(bl);
            this.vectorWCurveRB.setEnabled(bl);
            int n = 1;
            JRadioButton jRadioButton = SwingUtils.getSelection(this.fieldDisplayRBGroup);
            int n2 = n = jRadioButton == this.fullFieldRB ? 2 : n;
            if (this.fullFieldRB.isSelected()) {
                n = 2;
            }
            if (this.hideFieldRB.isSelected()) {
                n = 1;
            }
            if (this.curveRB.isSelected()) {
                n = 3;
            }
            if (this.vectorWCurveRB.isSelected()) {
                n = 4;
                EmfControlPanel.this.module.setSingleVectorRowRepresentation(EmfConfig.SINGLE_VECTOR_ROW_PINNED);
            }
            EmfControlPanel.this.module.setFieldDisplay(n);
        }

        private class FieldViewRBActionListener
        implements ActionListener {
            private FieldViewRBActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OptionControlPane.this.setFieldView();
            }
        }
    }
}

