/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.radiowaves.common_1200.graphics.ApparatusPanel;
import edu.colorado.phet.radiowaves.common_1200.graphics.BufferedImageGraphic;
import edu.colorado.phet.radiowaves.model.Electron;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ElectronGraphic
extends BufferedImageGraphic
implements SimpleObserver,
TransformListener {
    private Point location = new Point();
    private ApparatusPanel apparatusPanel;
    private Electron electron;
    private AffineTransform atx = new AffineTransform();
    private AffineTransform containerTx;
    static String s_imageName = "radio-waves/images/blue-sml.gif";
    static BufferedImage s_particleImage;

    public ElectronGraphic(ApparatusPanel apparatusPanel, BufferedImage bufferedImage, Electron electron) {
        super(bufferedImage);
        this.apparatusPanel = apparatusPanel;
        this.electron = electron;
        electron.addObserver(this);
    }

    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
        this.containerTx = modelViewTransform2D.getAffineTransform();
        this.update();
    }

    public void update() {
        this.location.x = (int)this.electron.getCurrentPosition().getX();
        this.location.y = (int)this.electron.getCurrentPosition().getY();
        this.atx.setToTranslation(this.location.x - this.getImage().getWidth(null) / 2, this.location.y - this.getImage().getHeight(null) / 2);
        AffineTransform affineTransform = new AffineTransform();
        if (this.containerTx != null) {
            affineTransform.concatenate(this.containerTx);
        }
        affineTransform.concatenate(this.atx);
        super.setTransform(affineTransform);
        this.apparatusPanel.repaint();
    }

    private Image getImage() {
        return super.getBufferedImage();
    }

    static {
        try {
            s_particleImage = ImageLoader.loadBufferedImage(s_imageName);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

