/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class StripChart
extends JPanel {
    private int width;
    private int height;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private Rectangle2D plotArea;
    private Color plotBackground = Color.WHITE;
    private double[] data;
    private int numData = 0;
    private double timeStep;
    private Point plotAreaULC;
    private double yScale;
    private int yOffset;
    private int tickLoc = 0;
    private int tickSpace = 20;
    private Color tickColor = new Color(128, 128, 128);

    public StripChart(int n, int n2, double d, double d2, double d3, double d4, double d5) {
        this.width = n;
        this.height = n2;
        this.minX = d;
        this.minY = d3;
        this.maxX = d2;
        this.maxY = d4;
        this.timeStep = d5;
        this.data = new double[n];
        this.yScale = (double)n2 / (d4 - d3);
        this.yOffset = (int)(d3 * this.yScale);
        this.setLayout(null);
        this.plotAreaULC = new Point(10, 10);
        this.setPreferredSize(new Dimension(this.plotAreaULC.x * 2 + n, this.plotAreaULC.y * 2 + n2));
        this.plotArea = new Rectangle2D.Double(this.plotAreaULC.x, this.plotAreaULC.y, n, n2);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.plotBackground);
        graphics2D.fill(this.plotArea);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.plotArea);
        graphics2D.setColor(Color.RED);
        graphics2D.setColor(this.tickColor);
        graphics2D.drawLine(this.plotAreaULC.x, this.plotAreaULC.y + this.height / 2, this.plotAreaULC.x + this.width, this.plotAreaULC.y + this.height / 2);
        for (int i = 1; i < this.data.length; ++i) {
            int n = (int)(this.data[i - 1] * this.yScale);
            int n2 = (int)(this.data[i] * this.yScale);
            if (i % this.tickSpace == this.tickLoc) {
                graphics2D.setColor(this.tickColor);
                graphics2D.drawLine(i + this.plotAreaULC.x, this.plotAreaULC.y, i + this.plotAreaULC.x, this.plotAreaULC.y + this.height);
            }
            graphics2D.setColor(Color.RED);
            graphics2D.drawLine(i - 1 + this.plotAreaULC.x, n + this.plotAreaULC.y - this.yOffset, i + this.plotAreaULC.x, n2 + this.plotAreaULC.y - this.yOffset);
        }
    }

    public void addDatum(double d, double d2) {
        this.tickLoc = (this.tickLoc + 1) % this.tickSpace;
        for (int i = this.data.length - 1; i > 0; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[0] = d;
        this.numData = this.numData < this.data.length ? this.numData + 1 : this.numData;
        this.repaint((int)this.plotArea.getX(), (int)this.plotArea.getY(), (int)this.plotArea.getWidth(), (int)this.plotArea.getHeight());
    }
}

