/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.model.movement;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.radiowaves.model.EMFSineFunction;
import edu.colorado.phet.radiowaves.model.Electron;
import edu.colorado.phet.radiowaves.model.movement.MovementType;
import java.awt.geom.Point2D;
import java.util.Observable;

public class SinusoidalMovement
extends Observable
implements MovementType {
    private EMFSineFunction sineFunction = new EMFSineFunction();
    private float frequency;
    private float amplitude;
    private Point2D nextPosition = new Point2D.Double();
    private float omega;
    private float runningTime;
    private Vector2D velocity = new Vector2D();

    public SinusoidalMovement(float f, float f2) {
        this.frequency = f;
        this.amplitude = f2;
        this.omega = SinusoidalMovement.computeOmega(f);
    }

    public void stepInTime(Electron electron, double d) {
        this.runningTime = (float)((double)this.runningTime + d);
        Point2D point2D = electron.getStartPosition();
        this.nextPosition = this.getNextPosition(point2D, this.runningTime);
        electron.setCurrentPosition(this.nextPosition);
    }

    public Vector2D getVelocity(Electron electron) {
        this.velocity.setY(this.omega * (float)Math.cos(this.omega * this.runningTime));
        return this.velocity;
    }

    public float getAcceleration(Electron electron) {
        return (float)((double)(-this.amplitude * this.omega * this.omega) * Math.sin(this.omega * this.runningTime));
    }

    public Point2D getNextPosition(Point2D point2D, double d) {
        float f = this.sineFunction.valueAtTime(this.frequency, this.amplitude, (float)d);
        Math.sin((double)this.frequency * Math.PI * 2.0 * d);
        this.nextPosition.setLocation(point2D.getX(), point2D.getY() + (double)f);
        return this.nextPosition;
    }

    public void setFrequency(float f) {
        this.frequency = f;
        this.omega = SinusoidalMovement.computeOmega(f);
    }

    public void setAmplitude(float f) {
        this.amplitude = f;
    }

    public float getMaxAcceleration(Electron electron) {
        return -this.amplitude * this.omega * this.omega;
    }

    public void setRunningTime(float f) {
        this.runningTime = f;
        if (f == Float.POSITIVE_INFINITY) {
            System.out.println("");
        }
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getRunningTime() {
        return this.runningTime;
    }

    private static float computeOmega(float f) {
        return (float)((double)f * Math.PI * 2.0);
    }
}

