/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.model.movement;

import edu.colorado.phet.common.phetcommon.math.MedianFilter;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.radiowaves.model.Electron;
import edu.colorado.phet.radiowaves.model.movement.MovementType;
import java.awt.geom.Point2D;

public class ManualMovement
implements MovementType {
    private Point2D position;
    private static int s_posHistoryLength = 10;
    private int numHistoryEntries;
    private float[] yPosHistory = new float[s_posHistoryLength];
    private double[] yVHistory = new double[s_posHistoryLength - 1];
    private double[] yAHistory = new double[s_posHistoryLength - 2];
    private float vAve;
    private float aAve;
    private Vector2D velocity = new Vector2D();
    private MedianFilter dataFilter = new MedianFilter(this.yVHistory);

    public void setPosition(Point2D point2D) {
        this.position = point2D;
    }

    public void stepInTime(Electron electron, double d) {
        if (this.position != null) {
            this.numHistoryEntries = Math.min(this.numHistoryEntries + 1, s_posHistoryLength);
            electron.setCurrentPosition(this.position);
            for (int i = this.yPosHistory.length - 1; i > 0; --i) {
                this.yPosHistory[i] = this.yPosHistory[i - 1];
            }
            this.yPosHistory[0] = (float)electron.getCurrentPosition().getY();
            this.computeKinetics();
        }
    }

    private void computeKinetics() {
        int n;
        this.vAve = 0.0f;
        for (n = 0; n < this.numHistoryEntries - 1; ++n) {
            float f = this.yPosHistory[n + 1] - this.yPosHistory[n];
            this.yVHistory[n] = f;
            this.vAve += f;
        }
        this.vAve /= (float)this.yVHistory.length;
        this.velocity.setX(this.vAve);
        this.dataFilter.filter(3);
        this.aAve = 0.0f;
        for (n = 0; n < this.numHistoryEntries - 2; ++n) {
            double d;
            this.yAHistory[n] = d = this.yVHistory[n + 1] - this.yVHistory[n];
            this.aAve = (float)((double)this.aAve + d);
        }
        this.aAve /= (float)this.yAHistory.length;
    }

    public Vector2D getVelocity(Electron electron) {
        return this.velocity;
    }

    public float getAcceleration(Electron electron) {
        return this.aAve;
    }

    public float getMaxAcceleration(Electron electron) {
        return 0.1f;
    }
}

