/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.radiowaves.model.Electron;
import edu.colorado.phet.radiowaves.model.EmfModel;
import edu.colorado.phet.radiowaves.model.PositionConstrainedElectron;
import edu.colorado.phet.radiowaves.model.PositionConstraint;
import edu.colorado.phet.radiowaves.model.movement.ManualMovement;
import edu.colorado.phet.radiowaves.model.movement.SinusoidalMovement;
import java.awt.geom.Point2D;

public class EmfSensingElectron
extends PositionConstrainedElectron {
    private Point2D location;
    private Electron sourceElectron;
    private Vector2D aPrev = new Vector2D();

    public EmfSensingElectron(EmfModel emfModel, Point2D.Double double_, Electron electron, PositionConstraint positionConstraint) {
        super(emfModel, double_, positionConstraint);
        this.location = double_;
        this.sourceElectron = electron;
        this.setMovementStrategy(new ManualMovement());
        super.setRecordHistory(false);
    }

    public synchronized void stepInTime(double d) {
        super.stepInTime(d);
        Vector2D vector2D = this.getVelocity();
        if (this.sourceElectron.isFieldOff(this.getCurrentPosition().getX())) {
            vector2D.setX(0.0);
            vector2D.setY((float)(this.getStartPosition().getY() - this.getCurrentPosition().getY()) / 30.0f);
            this.location.setLocation(this.getCurrentPosition().getX(), this.getCurrentPosition().getY() + vector2D.getY() * d);
        } else {
            if (this.sourceElectron.getMovementTypeAt(this.location) instanceof SinusoidalMovement) {
                double d2 = this.sourceElectron.getPositionAt(this.location);
                double d3 = ((double)this.sourceElectron.getPositionAt(this.location) - this.getStartPosition().getY()) * 0.4;
                this.location.setLocation(this.location.getX(), this.getStartPosition().getY() + d3);
            } else {
                Vector2D vector2D2;
                Vector2D vector2D3 = vector2D2 = this.sourceElectron.getDynamicFieldAt(this.location);
                double d4 = this.getCurrentPosition().getX();
                double d5 = this.getCurrentPosition().getY();
                this.location = this.getCurrentPosition();
                d4 += vector2D.getX() * d;
                d5 = d5 + vector2D.getY() * (d /= 10.0) + vector2D3.getY() * d * d / 2.0;
                vector2D.setY(vector2D.getY() + (vector2D3.getY() + this.aPrev.getY()) / 2.0 * (double)((float)d));
                this.location.setLocation(d4, d5);
                this.aPrev.setX(vector2D3.getX());
                this.aPrev.setY(vector2D3.getY());
            }
            this.setCurrentPosition(this.location);
        }
    }

    public void recenter() {
        this.setCurrentPosition(this.getStartPosition());
        this.setMovementStrategy(new ManualMovement());
    }
}

