/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.radiowaves.RadioWavesApplication;
import edu.colorado.phet.radiowaves.model.EmfModel;
import edu.colorado.phet.radiowaves.model.movement.ManualMovement;
import edu.colorado.phet.radiowaves.model.movement.MovementType;
import edu.colorado.phet.radiowaves.model.movement.SinusoidalMovement;
import java.awt.geom.Point2D;

public class Electron
extends Body {
    private EmfModel model;
    private Point2D startPosition;
    private Point2D prevPosition = new Point2D.Double();
    private Point2D currentPosition = new Point2D.Double();
    private Vector2D velocity = new Vector2D();
    private MovementType movementStrategy;
    private Vector2D staticFieldStrength = new Vector2D();
    private Vector2D dynamicFieldStrength = new Vector2D();
    private int steps = 0;
    private Point2D[] positionHistory = new Point2D.Float[2000];
    private Vector2D[] accelerationHistory = new Vector2D[2000];
    private Vector2D[] maxAccelerationHistory = new Vector2D[2000];
    private MovementType[] movementStrategyHistory = new MovementType[2000];
    private boolean changeFreq;
    private float newFreq;
    private boolean changeAmplitude;
    private float newAmplitude;
    private boolean recordHistory = true;
    private static int s_stepSize = (int)RadioWavesApplication.s_speedOfLight;

    public Electron(EmfModel emfModel, Point2D.Double double_) {
        this.model = emfModel;
        this.startPosition = new Point2D.Double(double_.getX(), double_.getY());
        this.currentPosition = new Point2D.Double(double_.getX(), double_.getY());
        for (int i = 0; i < 2000; ++i) {
            this.positionHistory[i] = new Point2D.Float((float)double_.getX(), (float)double_.getY());
            this.accelerationHistory[i] = new Vector2D();
            this.maxAccelerationHistory[i] = new Vector2D();
        }
        this.movementStrategy = new ManualMovement();
    }

    public Point2D getCurrentPosition() {
        return this.currentPosition;
    }

    public synchronized void setCurrentPosition(Point2D point2D) {
        this.currentPosition.setLocation(point2D);
    }

    public void setMovementStrategy(MovementType movementType) {
        this.movementStrategy = movementType;
    }

    public void setRecordHistory(boolean bl) {
        this.recordHistory = bl;
    }

    public synchronized void stepInTime(double d) {
        SinusoidalMovement sinusoidalMovement;
        this.prevPosition.setLocation(this.currentPosition);
        this.movementStrategy.stepInTime(this, d);
        this.velocity = this.movementStrategy.getVelocity(this);
        if (this.recordHistory) {
            this.recordPosition(this.currentPosition);
        }
        if (this.changeFreq && this.movementStrategy instanceof SinusoidalMovement) {
            sinusoidalMovement = (SinusoidalMovement)this.movementStrategy;
            if (this.newFreq != 0.0f) {
                double d2 = sinusoidalMovement.getRunningTime() * (sinusoidalMovement.getFrequency() / (double)this.newFreq - 1.0);
                sinusoidalMovement.setRunningTime((float)(sinusoidalMovement.getRunningTime() + d2));
            }
            sinusoidalMovement.setFrequency(this.newFreq);
            this.changeFreq = false;
        }
        if (this.changeAmplitude && this.movementStrategy instanceof SinusoidalMovement && (this.prevPosition.getY() - this.startPosition.getY()) * (this.currentPosition.getY() - this.startPosition.getY()) <= 0.0) {
            sinusoidalMovement = (SinusoidalMovement)this.movementStrategy;
            sinusoidalMovement.setAmplitude(this.newAmplitude);
            this.changeAmplitude = false;
        }
        this.notifyObservers();
    }

    public synchronized void moveToNewPosition(Point2D point2D) {
        if (this.movementStrategy instanceof ManualMovement) {
            ((ManualMovement)this.movementStrategy).setPosition(point2D);
        }
    }

    private void recordPosition(Point2D point2D) {
        for (int i = 1999; i > s_stepSize - 1; --i) {
            this.positionHistory[i].setLocation(this.positionHistory[i - s_stepSize]);
            this.accelerationHistory[i].setX(this.accelerationHistory[i - s_stepSize].getX());
            this.accelerationHistory[i].setY(this.accelerationHistory[i - s_stepSize].getY());
            this.maxAccelerationHistory[i].setX(this.maxAccelerationHistory[i - s_stepSize].getX());
            this.maxAccelerationHistory[i].setY(this.maxAccelerationHistory[i - s_stepSize].getY());
            this.movementStrategyHistory[i] = this.movementStrategyHistory[i - s_stepSize];
        }
        Vector2D vector2D = this.accelerationHistory[0];
        double d = (vector2D.getY() - (double)(this.movementStrategy.getAcceleration(this) * 1000.0f)) / (double)s_stepSize;
        for (int i = 0; i < s_stepSize; ++i) {
            this.positionHistory[i].setLocation(point2D);
            this.accelerationHistory[i].setY((double)(this.movementStrategy.getAcceleration(this) * 1000.0f) + (double)i * d);
            this.maxAccelerationHistory[i].setY(this.movementStrategy.getMaxAcceleration(this) * 1000.0f);
            this.movementStrategyHistory[i] = this.movementStrategy;
        }
    }

    public Vector2D getVelocity() {
        return new Vector2D(this.velocity.getX(), this.velocity.getY());
    }

    public Point2D getStartPosition() {
        return this.startPosition;
    }

    public Vector2D getStaticFieldAt(Point2D point2D) {
        this.staticFieldStrength.setX((float)(point2D.getX() - this.getCurrentPosition().getX()));
        this.staticFieldStrength.setY((float)(point2D.getY() - this.getCurrentPosition().getY()));
        this.staticFieldStrength.normalize();
        double d = point2D.distance(this.getCurrentPosition());
        this.staticFieldStrength.scale(50000.0f / (float)(d * d));
        return this.staticFieldStrength;
    }

    public Vector2D getDynamicFieldAt(Point2D point2D) {
        double d = point2D.distance(this.getStartPosition());
        if (d == 0.0) {
            throw new RuntimeException("Asked for r=0 field.");
        }
        Point2D point2D2 = this.positionHistory[(int)d];
        this.dynamicFieldStrength.setX((float)(-(point2D.getY() - point2D2.getY())));
        if (point2D.getX() - point2D2.getX() < 0.0) {
            this.dynamicFieldStrength.setX(-this.dynamicFieldStrength.getX());
        }
        this.dynamicFieldStrength.setY((float)Math.abs(point2D.getX() - point2D2.getX()));
        this.dynamicFieldStrength.normalize();
        float f = this.getAccelerationAt((int)d);
        float f2 = 0.0f;
        f2 = d == 0.0 ? 1.0f : (float)Math.pow(d, 0.5);
        this.dynamicFieldStrength.scale(f / f2);
        if (d == 0.0) {
            d = 1.0;
        }
        float f3 = (float)(Math.abs(point2D.getX() - this.getStartPosition().getX()) / d);
        this.dynamicFieldStrength.scale(f3);
        return this.dynamicFieldStrength;
    }

    private float getAccelerationAt(int n) {
        return (float)this.accelerationHistory[Math.min(n, this.accelerationHistory.length - 1)].getY();
    }

    public float getPositionAt(int n) {
        return (float)this.positionHistory[Math.min(n, this.positionHistory.length - 1)].getY();
    }

    public float getPositionAt(Point2D point2D) {
        int n = (int)point2D.distance(this.currentPosition);
        return this.getPositionAt(n);
    }

    public MovementType getMovementTypeAt(Point2D point2D) {
        int n = (int)point2D.distance(this.currentPosition);
        return this.movementStrategyHistory[n];
    }

    public double getMass() {
        float f = (float)this.getVelocity().getMagnitude();
        float f2 = (float)Math.sqrt(1.0 - (double)(f * f) / (RadioWavesApplication.s_speedOfLight * RadioWavesApplication.s_speedOfLight));
        if (f2 < 1.0f) {
            System.out.println(f2);
        }
        float f3 = 1.0f / f2;
        return f3;
    }

    public void setFrequency(float f) {
        if (this.movementStrategy instanceof SinusoidalMovement) {
            this.changeFreq = true;
            this.newFreq = f;
        }
    }

    public void setAmplitude(float f) {
        if (this.movementStrategy instanceof SinusoidalMovement) {
            this.changeAmplitude = true;
            this.newAmplitude = f;
        }
    }

    public boolean isFieldOff(double d) {
        boolean bl = true;
        for (int i = 0; i < this.accelerationHistory.length && i < (int)d && bl; ++i) {
            Vector2D vector2D = this.accelerationHistory[i];
            if (vector2D.getX() == 0.0 && vector2D.getY() == 0.0) continue;
            bl = false;
        }
        return bl;
    }
}

