/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.model;

import edu.colorado.phet.radiowaves.model.PositionConstraint;
import java.awt.geom.Point2D;

public class Antenna
implements PositionConstraint {
    private Point2D end1;
    private Point2D end2;
    private double maxX;
    private double minX;
    private double maxY;
    private double minY;
    private double m;
    private double b;
    private double r;
    private double theta;

    public Antenna(Point2D point2D, Point2D point2D2) {
        this.end1 = point2D;
        this.end2 = point2D2;
        this.maxX = Math.max(point2D.getX(), point2D2.getX());
        this.maxY = Math.max(point2D.getY(), point2D2.getY());
        this.minX = Math.min(point2D.getX(), point2D2.getX());
        this.minY = Math.min(point2D.getY(), point2D2.getY());
        this.r = Math.sqrt(Math.pow(point2D.getX() - point2D2.getX(), 2.0) + Math.pow(point2D.getY() - point2D2.getY(), 2.0));
        this.theta = Math.atan((point2D.getY() - point2D2.getY()) / (point2D.getX() - point2D2.getX()));
        if (point2D.getX() == point2D2.getX()) {
            this.theta = 1.5707963267948966;
            this.m = Double.POSITIVE_INFINITY;
            this.b = Double.NaN;
        } else {
            this.m = (point2D.getY() - point2D2.getY()) / (point2D.getX() - point2D2.getX());
            this.b = point2D.getY() - point2D.getX() * this.m;
        }
    }

    public Point2D constrainPosition(Point2D point2D) {
        if (point2D.getX() > this.maxX) {
            point2D.setLocation(this.maxX, this.getYForX(this.maxX, point2D.getY()));
        }
        if (point2D.getX() < this.minX) {
            point2D.setLocation(this.minX, this.getYForX(this.minX, point2D.getY()));
        }
        if (point2D.getY() > this.maxY) {
            point2D.setLocation(this.getXForY(this.maxY, point2D.getX()), this.maxY);
        }
        if (point2D.getY() < this.minY) {
            point2D.setLocation(this.getXForY(this.minY, point2D.getX()), this.minY);
        }
        point2D.setLocation(point2D.getX(), this.getYForX(point2D.getX(), point2D.getY()));
        return point2D;
    }

    private double getYForX(double d, double d2) {
        if (this.m == Double.POSITIVE_INFINITY) {
            return d2;
        }
        return this.m * d + this.b;
    }

    private double getXForY(double d, double d2) {
        if (this.m == 0.0 || this.m == Double.POSITIVE_INFINITY) {
            return d2;
        }
        return (d - this.b) / this.m;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinY() {
        return this.minY;
    }
}

