/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.radiowaves.common_1200.graphics.PhetGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class PhetImageGraphic
extends PhetGraphic {
    private BufferedImage image;
    private AffineTransform transform;
    private boolean shapeDirty = true;
    private Shape shape;

    public PhetImageGraphic(Component component, BufferedImage bufferedImage) {
        super(component);
        this.image = bufferedImage;
        this.transform = new AffineTransform();
    }

    public Shape getShape() {
        if (this.shapeDirty) {
            if (this.image == null) {
                return null;
            }
            Rectangle rectangle = new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight());
            this.shape = this.transform.createTransformedShape(rectangle);
            this.shapeDirty = false;
        }
        return this.shape;
    }

    public boolean contains(int n, int n2) {
        return this.isVisible() && this.getShape() != null && this.getShape().contains(n, n2);
    }

    protected Rectangle determineBounds() {
        return this.getShape() == null ? null : this.getShape().getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible() && this.image != null) {
            graphics2D.drawRenderedImage(this.image, this.transform);
        }
    }
}

