/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.common.phetgraphics.view.util.CompositeMouseInputListener;
import edu.colorado.phet.radiowaves.common_1200.graphics.InteractiveGraphic;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Stack;

public abstract class PhetGraphic
implements InteractiveGraphic {
    private Point location = new Point();
    private Rectangle lastBounds = null;
    private Rectangle bounds = null;
    private Component component;
    protected boolean visible = true;
    private boolean boundsDirty = true;
    private Stack graphicsStates = new Stack();
    private CompositeMouseInputListener mouseInputListener = new CompositeMouseInputListener();

    protected PhetGraphic(Component component) {
        this.component = component;
    }

    protected void syncBounds() {
        if (this.boundsDirty) {
            this.rebuildBounds();
            this.boundsDirty = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean contains(int n, int n2) {
        if (this.visible) {
            this.syncBounds();
            return this.bounds.contains(n, n2);
        }
        return false;
    }

    private void rebuildBounds() {
        Rectangle rectangle = this.determineBounds();
        if (rectangle != null) {
            if (this.bounds == null) {
                this.bounds = new Rectangle(rectangle);
            } else {
                this.bounds.setBounds(rectangle);
            }
            if (this.lastBounds == null) {
                this.lastBounds = new Rectangle(this.bounds);
            }
        }
    }

    public void repaint() {
        if (this.isVisible()) {
            this.forceRepaint();
        }
    }

    protected void forceRepaint() {
        this.syncBounds();
        if (this.lastBounds != null) {
            this.component.repaint(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        }
        if (this.bounds != null) {
            this.component.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
        if (this.bounds != null) {
            this.lastBounds.setBounds(this.bounds);
        }
    }

    protected abstract Rectangle determineBounds();

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseReleased(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseExited(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseMoved(mouseEvent);
        }
    }
}

