/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.ShadowTextGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HelpItem
implements Graphic {
    ArrayList shadowTextGraphics = new ArrayList();
    int horizontalAlignment;
    int verticalAlignment;
    private Font font = new PhetFont(1, 16);
    private String text;
    private Point2D.Double location;
    private Color shadowColor;
    private Color foregroundColor;
    boolean inited = false;

    public HelpItem(String string, double d, double d2, int n, int n2) {
        this.horizontalAlignment = n;
        this.verticalAlignment = n2;
        this.text = string;
        this.location = new Point2D.Double(d, d2);
        this.shadowColor = Color.black;
        this.foregroundColor = new Color(156, 156, 0);
    }

    public static String[] tokenizeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.inited) {
            this.init(graphics2D);
            this.inited = true;
        }
        for (int i = 0; i < this.shadowTextGraphics.size(); ++i) {
            ShadowTextGraphic shadowTextGraphic = (ShadowTextGraphic)this.shadowTextGraphics.get(i);
            shadowTextGraphic.paint(graphics2D);
        }
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        for (int i = 0; i < this.shadowTextGraphics.size(); ++i) {
            ShadowTextGraphic shadowTextGraphic = (ShadowTextGraphic)this.shadowTextGraphics.get(i);
            shadowTextGraphic.setShadowColor(color);
        }
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        for (int i = 0; i < this.shadowTextGraphics.size(); ++i) {
            ShadowTextGraphic shadowTextGraphic = (ShadowTextGraphic)this.shadowTextGraphics.get(i);
            shadowTextGraphic.setForegroundColor(color);
        }
    }

    private void init(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        this.shadowTextGraphics = new ArrayList();
        String[] stringArray = HelpItem.tokenizeString(this.text);
        int n = 0;
        double d = 0.0;
        switch (this.horizontalAlignment) {
            case 3: {
                d = this.getMaxStrLen(stringArray, graphics2D, fontMetrics);
                n = (int)(this.location.getX() - d - fontMetrics.getStringBounds(" ", graphics2D).getWidth());
                break;
            }
            case 5: {
                n = (int)(this.location.getX() + fontMetrics.getStringBounds(" ", graphics2D).getWidth());
                break;
            }
            case 4: {
                d = this.getMaxStrLen(stringArray, graphics2D, fontMetrics);
                n = (int)(this.location.getX() - d / 2.0);
            }
        }
        double d2 = 0.0;
        switch (this.verticalAlignment) {
            case 1: {
                d2 = -stringArray.length * (fontMetrics.getHeight() + fontMetrics.getLeading());
                break;
            }
            case 2: {
                d2 = 0.0;
                break;
            }
            case 4: {
                d2 = -(stringArray.length + 1) * (fontMetrics.getHeight() + fontMetrics.getLeading()) / 2;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = (int)d2 + (int)this.location.getY() + (i + 1) * (fontMetrics.getHeight() + fontMetrics.getLeading());
            ShadowTextGraphic shadowTextGraphic = new ShadowTextGraphic(this.font, stringArray[i], 1, 1, n, n2, this.foregroundColor, this.shadowColor);
            this.shadowTextGraphics.add(shadowTextGraphic);
        }
    }

    private double getMaxStrLen(String[] stringArray, Graphics2D graphics2D, FontMetrics fontMetrics) {
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            double d2 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            d = d2 > d ? d2 : d;
        }
        return d;
    }
}

