/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.common.phetgraphics.view.util.CompositeMouseInputListener;
import edu.colorado.phet.common.phetgraphics.view.util.CursorControl;
import edu.colorado.phet.radiowaves.common_1200.graphics.Boundary;
import edu.colorado.phet.radiowaves.common_1200.graphics.BoundedGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.InteractiveGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.Translatable;
import edu.colorado.phet.radiowaves.common_1200.graphics.TranslationControl;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

public class DefaultInteractiveGraphic
implements InteractiveGraphic {
    private Graphic graphic;
    private CompositeMouseInputListener mouseControl;
    private Boundary boundary;
    private CursorControl handControl;
    private boolean visible = true;

    public DefaultInteractiveGraphic(BoundedGraphic boundedGraphic) {
        this(boundedGraphic, boundedGraphic);
    }

    public DefaultInteractiveGraphic(Graphic graphic, Boundary boundary) {
        this.graphic = graphic;
        this.boundary = boundary;
        this.mouseControl = new CompositeMouseInputListener();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.visible) {
            this.graphic.paint(graphics2D);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mouseReleased(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mouseExited(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.visible) {
            this.mouseControl.mouseMoved(mouseEvent);
        }
    }

    public boolean contains(int n, int n2) {
        return this.visible && this.boundary.contains(n, n2);
    }

    public void setGraphic(Graphic graphic) {
        this.graphic = graphic;
    }

    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }

    public void addCursorHandBehavior() {
        if (this.handControl == null) {
            this.handControl = new CursorControl(Cursor.getPredefinedCursor(12));
            this.mouseControl.addMouseInputListener(this.handControl);
        }
    }

    public void addTranslationBehavior(Translatable translatable) {
        this.mouseControl.addMouseInputListener(new TranslationControl(translatable));
    }
}

