/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.radiowaves.common_1200.graphics.Boundary;
import edu.colorado.phet.radiowaves.common_1200.graphics.CompositeGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class CompositeInteractiveGraphicMouseDelegator
implements MouseInputListener {
    CompositeGraphic compositeInteractiveGraphic;
    MouseInputListener activeUnit;

    public CompositeInteractiveGraphicMouseDelegator(CompositeGraphic compositeGraphic) {
        this.compositeInteractiveGraphic = compositeGraphic;
    }

    public void handleEntranceAndExit(MouseEvent mouseEvent) {
        MouseInputListener mouseInputListener = this.getLeaf(mouseEvent.getPoint(), this.compositeInteractiveGraphic);
        if (mouseInputListener == null) {
            if (this.activeUnit != null) {
                this.activeUnit.mouseExited(mouseEvent);
                this.activeUnit = null;
            }
        } else if (this.activeUnit != mouseInputListener) {
            if (this.activeUnit == null) {
                this.activeUnit = mouseInputListener;
                this.activeUnit.mouseEntered(mouseEvent);
            } else if (this.activeUnit != mouseInputListener) {
                this.activeUnit.mouseExited(mouseEvent);
                this.activeUnit = mouseInputListener;
                this.activeUnit.mouseEntered(mouseEvent);
            }
        }
    }

    private MouseInputListener getLeaf(Point point, CompositeGraphic compositeGraphic) {
        Graphic[] graphicArray = compositeGraphic.getGraphics();
        MouseInputListener mouseInputListener = null;
        for (int i = graphicArray.length - 1; mouseInputListener == null && i >= 0; --i) {
            Boundary boundary;
            if (graphicArray[i] instanceof CompositeGraphic) {
                boundary = (CompositeGraphic)graphicArray[i];
                if (!((CompositeGraphic)boundary).isVisible()) continue;
                mouseInputListener = this.getLeaf(point, (CompositeGraphic)boundary);
                continue;
            }
            if (!(graphicArray[i] instanceof MouseInputListener) || !(graphicArray[i] instanceof Boundary) || !(boundary = (Boundary)((Object)graphicArray[i])).contains(point.x, point.y)) continue;
            mouseInputListener = (MouseInputListener)((Object)graphicArray[i]);
        }
        return mouseInputListener;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
        if (this.activeUnit != null) {
            this.activeUnit.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
        if (this.activeUnit != null) {
            this.activeUnit.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.activeUnit != null) {
            this.activeUnit.mouseReleased(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.activeUnit != null) {
            this.activeUnit.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
        if (this.activeUnit != null) {
            this.activeUnit.mouseMoved(mouseEvent);
        }
    }
}

