/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.common.phetcommon.util.MultiMap;
import edu.colorado.phet.radiowaves.common_1200.graphics.Boundary;
import edu.colorado.phet.radiowaves.common_1200.graphics.BoundedGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

public class CompositeGraphic
implements BoundedGraphic {
    private MultiMap graphicMap = new MultiMap();
    private boolean visible = true;

    public void paint(Graphics2D graphics2D) {
        if (this.visible) {
            Iterator iterator = this.graphicMap.iterator();
            while (iterator.hasNext()) {
                Graphic graphic = (Graphic)iterator.next();
                graphic.paint(graphics2D);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean contains(int n, int n2) {
        if (this.visible) {
            Iterator iterator = this.graphicMap.iterator();
            while (iterator.hasNext()) {
                Boundary boundary;
                Object e = iterator.next();
                if (!(e instanceof Boundary) || !(boundary = (Boundary)e).contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeGraphic(Graphic graphic) {
        this.graphicMap.removeValue(graphic);
    }

    public Graphic[] getGraphics() {
        Iterator iterator = this.graphicMap.iterator();
        ArrayList<Graphic> arrayList = new ArrayList<Graphic>();
        while (iterator.hasNext()) {
            Graphic graphic = (Graphic)iterator.next();
            arrayList.add(graphic);
        }
        return arrayList.toArray(new Graphic[0]);
    }

    public void addGraphic(Graphic graphic, double d) {
        this.graphicMap.put(new Double(d), graphic);
    }
}

