/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.radiowaves.common_1200.graphics.BoundedGraphic;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BufferedImageGraphic
implements BoundedGraphic {
    private BufferedImage image;
    protected AffineTransform transform = new AffineTransform();
    private boolean shapeDirty = true;
    private Shape sh;

    public BufferedImageGraphic(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        if (bufferedImage == null) {
            throw new RuntimeException("Null image.");
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.image != null && this.transform != null) {
            graphics2D.drawRenderedImage(this.image, this.transform);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
        this.shapeDirty = true;
    }

    public boolean contains(int n, int n2) {
        return this.getShape().contains(n, n2);
    }

    public Shape getShape() {
        if (this.shapeDirty || this.sh == null) {
            Rectangle rectangle = new Rectangle(this.image.getWidth(), this.image.getHeight());
            this.sh = this.transform.createTransformedShape(rectangle);
            this.shapeDirty = false;
        }
        return this.sh;
    }
}

