/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.common_1200.graphics;

import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.radiowaves.common_1200.graphics.CompositeGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.CompositeInteractiveGraphicMouseDelegator;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.GraphicsSetup;
import edu.colorado.phet.radiowaves.common_1200.graphics.PhetGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.JPanel;

public class ApparatusPanel
extends JPanel {
    private BasicStroke borderStroke = new BasicStroke(1.0f, 1, 1);
    CompositeGraphic graphic = new CompositeGraphic();
    CompositeInteractiveGraphicMouseDelegator mouseDelegator = new CompositeInteractiveGraphicMouseDelegator(this.graphic);
    ArrayList graphicsSetups = new ArrayList();

    public ApparatusPanel() {
        super(null);
        this.addMouseListener(this.mouseDelegator);
        this.addMouseMotionListener(this.mouseDelegator);
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        for (int i = 0; i < this.graphicsSetups.size(); ++i) {
            object = (GraphicsSetup)this.graphicsSetups.get(i);
            object.setup(graphics2D);
        }
        this.graphic.paint(graphics2D);
        Color color = graphics2D.getColor();
        object = graphics2D.getStroke();
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(this.borderStroke);
        Rectangle rectangle = new Rectangle(0, 0, (int)this.getBounds().getWidth() - 1, (int)this.getBounds().getHeight() - 1);
        graphics2D.draw(rectangle);
        graphics2D.setColor(color);
        graphics2D.setStroke((Stroke)object);
        graphicsState.restoreGraphics();
    }

    public void addGraphic(Graphic graphic, double d) {
        this.graphic.addGraphic(graphic, d);
        if (graphic instanceof PhetGraphic) {
            PhetGraphic phetGraphic = (PhetGraphic)graphic;
            phetGraphic.repaint();
        }
    }

    public void removeGraphic(Graphic graphic) {
        this.graphic.removeGraphic(graphic);
    }
}

