/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.radiowaves.EmfModule;
import edu.colorado.phet.radiowaves.view.WaveMediumGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class RadioWavesApplication
extends PhetApplication {
    public static double s_speedOfLight = 6.0;

    public RadioWavesApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        ConstantDtClock constantDtClock = new ConstantDtClock(40, 0.5);
        final EmfModule emfModule = new EmfModule(constantDtClock);
        this.addModule(emfModule);
        JMenu jMenu = new JMenu("Options");
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Fade scalar representation");
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaveMediumGraphic.Y_GRADIENT = jCheckBoxMenuItem.isSelected();
                emfModule.setFieldSense(emfModule.getFieldSense());
            }
        });
        jMenu.add(jCheckBoxMenuItem);
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new RadioWavesApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "radio-waves");
        phetApplicationConfig.getLookAndFeel().setBackgroundColor(new Color(255, 255, 220));
        phetApplicationConfig.getLookAndFeel().setFont(new PhetFont(PhetFont.getDefaultFontSize(), true));
        phetApplicationConfig.getLookAndFeel().setTitledBorderTitleColor(Color.BLACK);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

