/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Command;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.radiowaves.EmfConfig;
import edu.colorado.phet.radiowaves.RadioWavesResources;
import edu.colorado.phet.radiowaves.command.AddTransmittingElectronCmd;
import edu.colorado.phet.radiowaves.command.DynamicFieldIsEnabledCmd;
import edu.colorado.phet.radiowaves.command.SetMovementCmd;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.HelpItem;
import edu.colorado.phet.radiowaves.model.Antenna;
import edu.colorado.phet.radiowaves.model.EmfModel;
import edu.colorado.phet.radiowaves.model.EmfSensingElectron;
import edu.colorado.phet.radiowaves.model.PositionConstrainedElectron;
import edu.colorado.phet.radiowaves.model.movement.ManualMovement;
import edu.colorado.phet.radiowaves.model.movement.MovementType;
import edu.colorado.phet.radiowaves.model.movement.SinusoidalMovement;
import edu.colorado.phet.radiowaves.util.StripChart;
import edu.colorado.phet.radiowaves.view.EmfControlPanel;
import edu.colorado.phet.radiowaves.view.EmfPanel;
import edu.colorado.phet.radiowaves.view.ReceivingElectronGraphic;
import edu.colorado.phet.radiowaves.view.StripChartDelegate;
import edu.colorado.phet.radiowaves.view.TransmitterElectronGraphic;
import edu.colorado.phet.radiowaves.view.WaveMediumGraphic;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class EmfModule
extends PiccoloModule {
    final double HELP_LAYER_NUMBER = Double.POSITIVE_INFINITY;
    final double WIGGLE_ME_LAYER_NUMBER = 5.0;
    private PositionConstrainedElectron electron;
    int fieldWidth = 1000;
    int fieldHeight = 700;
    private EmfSensingElectron receivingElectron;
    private Point2D.Double receivingElectronLoc;
    private Point2D.Double electronLoc;
    private StripChart receiverStripChart;
    private JDialog stripChartDlg;
    private StripChart senderStripChart;
    protected SinusoidalMovement sinusoidalMovement = new SinusoidalMovement(0.02f, 50.0f);
    private ManualMovement manualMovement = new ManualMovement();
    private EmfPanel apparatusPanel;
    private MovementType movementStrategy;
    private Graphic wiggleMeGraphic;
    private boolean beenWiggled;
    private final EmfModel model;
    private ModelViewTransform2D mvTx;
    private WaveMediumGraphic waveMediumGraphicB;
    private WaveMediumGraphic waveMediumGraphicA;
    private int fieldSense = 1;
    private final HelpItem helpItem;
    private Timer wiggleMeTimer = new Timer(10, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            EmfModule.this.apparatusPanel.repaint();
        }
    });

    public EmfModule(IClock iClock) {
        super(RadioWavesResources.getString("ModuleTitle.EmfModule"), iClock);
        this.model = new EmfModel(iClock);
        super.setModel(this.model);
        Point point = new Point(125, 300);
        this.mvTx = new ModelViewTransform2D(new Point2D.Double(-point.getX(), -point.getY()), new Point2D.Double((double)this.fieldWidth - point.getX(), (double)this.fieldHeight - point.getY()), new Point(0, 0), new Point(this.fieldWidth, this.fieldHeight));
        Antenna antenna = new Antenna(new Point2D.Double(point.getX(), point.getY() - 100.0), new Point2D.Double(point.getX(), point.getY() + 250.0));
        this.electronLoc = new Point2D.Double(point.getX(), point.getY());
        this.electron = new PositionConstrainedElectron(this.model, this.electronLoc, antenna);
        new AddTransmittingElectronCmd(this.model, this.electron).doIt();
        new DynamicFieldIsEnabledCmd(this.model, true).doIt();
        this.apparatusPanel = new EmfPanel(this.electron, point, this.fieldWidth, this.fieldHeight);
        this.mvTx.addTransformListener(this.apparatusPanel);
        this.apparatusPanel.addComponentListener(new ComponentAdapter(){
            boolean init = false;

            public void componentResized(ComponentEvent componentEvent) {
                if (!this.init) {
                    this.init = true;
                    double d = (double)EmfModule.this.fieldHeight / (double)EmfModule.this.fieldWidth;
                    EmfModule.this.mvTx.setModelBounds(new Rectangle2D.Double(0.0, 0.0, EmfModule.this.apparatusPanel.getWidth(), EmfModule.this.apparatusPanel.getHeight()));
                }
                EmfModule.this.mvTx.setViewBounds(EmfModule.this.apparatusPanel.getBounds());
            }
        });
        super.setSimulationPanel(this.apparatusPanel);
        TransmitterElectronGraphic transmitterElectronGraphic = new TransmitterElectronGraphic(this.apparatusPanel, this.electron, this);
        this.apparatusPanel.addGraphic(transmitterElectronGraphic, 5.0);
        this.mvTx.addTransformListener(transmitterElectronGraphic);
        Antenna antenna2 = new Antenna(new Point2D.Double(point.x + 679, this.electron.getStartPosition().getY() - 50.0), new Point2D.Double(point.x + 679, this.electron.getStartPosition().getY() + 75.0));
        this.receivingElectronLoc = new Point2D.Double(point.x + 680, this.electron.getStartPosition().getY());
        this.receivingElectron = new EmfSensingElectron(this.model, this.receivingElectronLoc, this.electron, antenna2);
        this.model.execute(new Command(){

            public void doIt() {
                EmfModule.this.model.addModelElement(EmfModule.this.receivingElectron);
            }
        });
        ReceivingElectronGraphic receivingElectronGraphic = new ReceivingElectronGraphic(this.apparatusPanel, this.receivingElectron);
        this.receivingElectron.addObserver(receivingElectronGraphic);
        this.apparatusPanel.addGraphic(receivingElectronGraphic, 5.0);
        this.mvTx.addTransformListener(receivingElectronGraphic);
        double d = (antenna.getMaxY() - antenna.getMinY()) / 2.0;
        this.receiverStripChart = new StripChart(200, 80, 0.0, 500.0, (double)this.electron.getPositionAt(0) + d, (double)this.electron.getPositionAt(0) - d, 1.0);
        this.senderStripChart = new StripChart(200, 80, 0.0, 500.0, (double)this.electron.getPositionAt(0) + d, (double)this.electron.getPositionAt(0) - d, 1.0);
        EmfControlPanel emfControlPanel = new EmfControlPanel(this.model, this);
        this.setControlPanel(emfControlPanel);
        this.createWiggleMeGraphic(point, this.mvTx);
        this.createScalarRepresentations();
        this.helpItem = new HelpItem(RadioWavesResources.getString("EmfModule.help1"), point.getX() + 15.0, point.getY() + 10.0, 5, 2);
        this.helpItem.setForegroundColor(Color.black);
        this.helpItem.setShadowColor(Color.gray);
        if (this.isHelpEnabled()) {
            this.apparatusPanel.addGraphic(this.helpItem, Double.POSITIVE_INFINITY);
        }
    }

    public boolean hasHelp() {
        return true;
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        if (bl) {
            this.apparatusPanel.addGraphic(this.helpItem, Double.POSITIVE_INFINITY);
        } else {
            this.apparatusPanel.removeGraphic(this.helpItem);
        }
    }

    private void createScalarRepresentations() {
        this.waveMediumGraphicA = new WaveMediumGraphic(this.electron, this.apparatusPanel, this.electronLoc, 800.0, 1);
        this.waveMediumGraphicB = new WaveMediumGraphic(this.electron, this.apparatusPanel, this.electronLoc, 200.0, -1);
    }

    public ModelViewTransform2D getMvTx() {
        return this.mvTx;
    }

    private void createWiggleMeGraphic(final Point point, final ModelViewTransform2D modelViewTransform2D) {
        this.wiggleMeGraphic = new Graphic(){
            Point2D.Double start = new Point2D.Double(0.0, 0.0);
            Point2D.Double stop = new Point2D.Double(point.getX() - 100.0, point.getY() - 10.0);
            Point2D.Double current = new Point2D.Double(this.start.getX(), this.start.getY());
            Font font = new PhetFont(16, true);

            public void paint(Graphics2D graphics2D) {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.transform(modelViewTransform2D.getAffineTransform());
                this.current.setLocation(this.current.x + (this.stop.x - this.current.x) * 0.02, this.current.y + (this.stop.y - this.current.y) * 0.04);
                graphics2D.setFont(this.font);
                graphics2D.setColor(new Color(0, 100, 0));
                String string = RadioWavesResources.getString("EmfModule.Wiggle");
                String string2 = RadioWavesResources.getString("EmfModule.Electron");
                graphics2D.drawString(string, (int)this.current.getX(), (int)this.current.getY() - graphics2D.getFontMetrics(this.font).getHeight());
                graphics2D.drawString(string2, (int)this.current.getX(), (int)this.current.getY());
                Point2D.Double double_ = new Point2D.Double(this.current.getX() + (double)SwingUtilities.computeStringWidth(graphics2D.getFontMetrics(this.font), string2) + 10.0, (int)this.current.getY() - graphics2D.getFontMetrics(this.font).getHeight() / 2);
                Point2D.Double double_2 = new Point2D.Double(double_.getX() + 15.0, double_.getY() + 12.0);
                Arrow arrow = new Arrow(double_, double_2, 6.0, 6.0, 2.0, 100.0, false);
                graphics2D.fill(arrow.getShape());
                graphics2D.setTransform(affineTransform);
            }
        };
        this.setWiggleMeGraphicState();
    }

    private void setWiggleMeGraphicState() {
        if (this.wiggleMeGraphic != null) {
            if (this.movementStrategy == this.manualMovement && !this.beenWiggled) {
                this.apparatusPanel.addGraphic(this.wiggleMeGraphic, 5.0);
                this.wiggleMeTimer.start();
            } else {
                this.apparatusPanel.removeGraphic(this.wiggleMeGraphic);
                this.wiggleMeTimer.stop();
            }
        }
    }

    public void setAutoscaleEnabled(boolean bl) {
        this.apparatusPanel.setAutoscaleEnabled(bl);
    }

    public void recenterElectrons() {
        this.receivingElectron.recenter();
        this.electron.moveToNewPosition(new Point((int)this.electronLoc.getX(), (int)this.electronLoc.getY()));
    }

    public JDialog setStripChartEnabled(boolean bl) {
        if (bl && this.stripChartDlg == null) {
            PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
            this.stripChartDlg = new JDialog((Frame)phetFrame, false);
            this.stripChartDlg.getContentPane().setLayout(new GridBagLayout());
            new StripChartDelegate(this.receivingElectron, this.receiverStripChart);
            new StripChartDelegate(this.electron, this.senderStripChart);
            this.stripChartDlg.setTitle(RadioWavesResources.getString("EmfModule.ChartTitle"));
            try {
                int n = 0;
                SwingUtils.addGridBagComponent(this.stripChartDlg.getContentPane(), new JLabel(RadioWavesResources.getString("EmfModule.Transmitter")), 0, n++, 1, 1, 0, 17);
                SwingUtils.addGridBagComponent(this.stripChartDlg.getContentPane(), this.senderStripChart, 0, n++, 1, 1, 0, 17);
                SwingUtils.addGridBagComponent(this.stripChartDlg.getContentPane(), new JLabel(RadioWavesResources.getString("EmfModule.TimeLabel")), 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this.stripChartDlg.getContentPane(), new JLabel(RadioWavesResources.getString("EmfModule.Receiver")), 0, n++, 1, 1, 0, 17);
                SwingUtils.addGridBagComponent(this.stripChartDlg.getContentPane(), this.receiverStripChart, 0, n++, 1, 1, 0, 17);
                SwingUtils.addGridBagComponent(this.stripChartDlg.getContentPane(), new JLabel(RadioWavesResources.getString("EmfModule.TimeLabel")), 0, n++, 1, 1, 0, 10);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            this.stripChartDlg.pack();
            SwingUtils.centerDialogInParent(this.stripChartDlg);
        }
        if (this.stripChartDlg != null) {
            this.stripChartDlg.setVisible(bl);
        }
        return this.stripChartDlg;
    }

    public void setMovementSinusoidal() {
        this.setWiggleMeGraphicState();
        this.movementStrategy = this.sinusoidalMovement;
        this.model.execute(new SetMovementCmd(this.model, this.sinusoidalMovement));
        this.setWiggleMeGraphicState();
    }

    public void setMovementManual() {
        this.movementStrategy = this.manualMovement;
        this.model.execute(new SetMovementCmd(this.model, this.manualMovement));
        this.setWiggleMeGraphicState();
    }

    public void displayStaticField(boolean bl) {
        this.apparatusPanel.displayStaticField(bl);
    }

    public void displayDynamicField(boolean bl) {
        this.apparatusPanel.displayDynamicField(bl);
    }

    public void setFieldSense(int n) {
        this.fieldSense = n;
        this.apparatusPanel.setFieldSense(n);
        Color color = null;
        if (n == -1) {
            color = EmfConfig.FIELD_COLOR;
        }
        if (n == 1) {
            color = EmfConfig.FORCE_COLOR;
        }
        if (color == null) {
            throw new RuntimeException("invalid fieldSense");
        }
        this.waveMediumGraphicA.setMaxAmplitudeColor(color);
        this.waveMediumGraphicB.setMaxAmplitudeColor(color);
        this.model.updateWhileClockIsPaused();
    }

    public int getFieldSense() {
        return this.fieldSense;
    }

    public void setFieldDisplay(int n) {
        this.apparatusPanel.setFieldDisplay(n);
        this.model.updateWhileClockIsPaused();
    }

    public void setSingleVectorRowRepresentation(Object object) {
        if (object == EmfConfig.SINGLE_VECTOR_ROW_CENTERED) {
            EmfConfig.SINGLE_VECTOR_ROW_OFFSET = 0.5;
        } else if (object == EmfConfig.SINGLE_VECTOR_ROW_PINNED) {
            EmfConfig.SINGLE_VECTOR_ROW_OFFSET = 0.0;
        } else {
            throw new RuntimeException("invalid representation");
        }
    }

    public void removeWiggleMeGraphic() {
        this.apparatusPanel.removeGraphic(this.wiggleMeGraphic);
        this.beenWiggled = true;
    }

    public void showMegaHelp() {
        JDialog jDialog = new JDialog((Frame)PhetApplication.getInstance().getPhetFrame(), false);
        try {
            final BufferedImage bufferedImage = ImageLoader.loadBufferedImage("radio-waves/images/emf.gif");
            final JPanel jPanel = new JPanel(){

                public void paint(Graphics graphics) {
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                    graphics.drawImage(bufferedImage, 0, 0, null);
                }
            };
            jPanel.setPreferredSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            AdjustmentListener adjustmentListener = new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    jPanel.repaint();
                }
            };
            jScrollPane.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
            jScrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
            jScrollPane.setPreferredSize(new Dimension(bufferedImage.getWidth(), 500));
            jDialog.setContentPane(jScrollPane);
            jDialog.pack();
            jDialog.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

