/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.quantumwaveinterference.model.PhotonWave;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityBeam;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.Photon;

public class PhotonBeam
extends IntensityBeam {
    private PhotonWave photonWave;
    private AbstractGunNode abstractGunNode;
    private Photon photon;
    private AbstractGunNode.MomentumChangeListener colorChangeHandler;

    public PhotonBeam(AbstractGunNode abstractGunNode, Photon photon) {
        super(photon);
        this.photon = photon;
        this.abstractGunNode = abstractGunNode;
        this.photonWave = this.createCylinderWave();
        super.setIntensityScale(1.0);
        this.photonWave.setIntensity(super.getTotalIntensity());
        photon.addMomentumChangeListerner(new AbstractGunNode.MomentumChangeListener(){

            public void momentumChanged(double d) {
                PhotonBeam.this.photonWave.setMomentum(d);
            }
        });
        this.colorChangeHandler = new AbstractGunNode.MomentumChangeListener(){

            public void momentumChanged(double d) {
                if (PhotonBeam.this.getGunParticle().isActive()) {
                    PhotonBeam.this.handleColorChange();
                }
            }
        };
        photon.addMomentumChangeListerner(this.colorChangeHandler);
        this.photonWave.setMomentum(photon.getStartPy());
    }

    protected PhotonWave createCylinderWave() {
        return new PhotonWave(this.getGunGraphic().getSchrodingerModule(), this.getGunGraphic().getDiscreteModel());
    }

    private void handleColorChange() {
        this.getGunGraphic().getSchrodingerModule().getQWIModel().clearWavefunction();
        this.getGunGraphic().getSchrodingerPanel().setPhoton(this.getPhoton());
    }

    public AbstractGunNode.MomentumChangeListener getColorChangeHandler() {
        return this.colorChangeHandler;
    }

    protected AbstractGunNode getGunGraphic() {
        return this.abstractGunNode;
    }

    public void setHighIntensityModeOn(boolean bl) {
        super.setHighIntensityModeOn(bl);
        if (bl) {
            this.photonWave.setOn();
            this.getGunGraphic().getSchrodingerPanel().setPhoton(this.getPhoton());
        } else {
            this.photonWave.setOff();
        }
    }

    public void setIntensity(double d) {
        super.setIntensity(d);
        if (this.photonWave != null) {
            this.photonWave.setIntensity(d);
        }
    }

    public void stepBeam() {
    }

    public Photon getPhoton() {
        return this.photon;
    }

    public void activate(IntensityGunNode intensityGunNode) {
        super.activate(intensityGunNode);
        this.getGunGraphic().getSchrodingerPanel().setPhoton(this.getPhoton());
    }

    public void deactivate(IntensityGunNode intensityGunNode) {
        super.deactivate(intensityGunNode);
        this.getGunGraphic().getSchrodingerPanel().setPhoton(null);
    }
}

