/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.quantumwaveinterference.view.gun.GunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityBeam;
import java.awt.Point;

public class ParticleBeam
extends IntensityBeam {
    private int numStepsBetweenFire = 4;
    private int lastFireTime = 0;
    private int time = 0;

    public ParticleBeam(GunParticle gunParticle) {
        super(gunParticle);
    }

    public void stepBeam() {
        ++this.time;
        if (this.isTimeToFire()) {
            this.autofire();
        }
    }

    private boolean isTimeToFire() {
        if (this.isHighIntensityModeOn()) {
            int n = this.getNumStepsBetweenFire();
            return this.time >= n + this.lastFireTime;
        }
        return false;
    }

    private int getNumStepsBetweenFire() {
        return this.numStepsBetweenFire;
    }

    private void autofire() {
        this.lastFireTime = this.time;
        this.getGunParticle().autofire();
    }

    public Point getGunLocation() {
        Point point = super.getGunLocation();
        point.y -= 35;
        return point;
    }
}

