/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends PaintImmediateDialog {
    public static int OK_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    private JList fontList;
    private JList sizeList;
    private JCheckBox cbBold;
    private JCheckBox cbItalic;
    private JTextArea txtSample;
    private int OPTION;
    private String[] sizes = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "30", "36", "48", "72"};
    ArrayList listeners = new ArrayList();

    public JFontChooser(Frame frame) {
        super(frame, true);
        this.setTitle("JFontChooser");
        this.OPTION = CANCEL_OPTION;
        this.fontList = new JList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 144);
            }
        };
        this.fontList.setSelectionMode(0);
        this.sizeList = new JList(this.sizes){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(25, 144);
            }
        };
        this.sizeList.setSelectionMode(0);
        this.cbBold = new JCheckBox("Bold");
        this.cbItalic = new JCheckBox("Italic");
        this.txtSample = new JTextArea(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(385, 80);
            }
        };
        this.txtSample.setText("The quick brown fox jumped over the fence");
        this.setFont(null);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFontChooser.this.updateFont();
            }
        };
        this.fontList.addListSelectionListener(listSelectionListener);
        this.sizeList.addListSelectionListener(listSelectionListener);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateFont();
            }
        };
        this.cbBold.addActionListener(actionListener);
        this.cbItalic.addActionListener(actionListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.fontList), "Center");
        jPanel.add((Component)new JScrollPane(this.sizeList), "East");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(this.cbBold);
        jPanel3.add(this.cbItalic);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel2.add((Component)jPanel4, "South");
        this.getContentPane().add((Component)jPanel2, "East");
        this.getContentPane().add((Component)new JScrollPane(this.txtSample), "South");
        this.setSize(200, 200);
        this.setResizable(false);
        this.pack();
    }

    private void updateFont() {
        this.txtSample.setFont(this.getCurrentFont());
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.fontChanged(this.getCurrentFont());
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setFont(Font font) {
        if (font == null && this.txtSample != null) {
            font = this.txtSample.getFont();
        }
        if (this.fontList != null && this.sizeList != null && this.cbBold != null && this.cbItalic != null) {
            this.fontList.setSelectedValue(font.getName(), true);
            this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
            this.sizeList.setSelectedValue("" + font.getSize(), true);
            this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
            this.cbBold.setSelected(font.isBold());
            this.cbItalic.setSelected(font.isItalic());
        }
    }

    public Font getFont() {
        if (this.OPTION == OK_OPTION) {
            return this.getCurrentFont();
        }
        return null;
    }

    private Font getCurrentFont() {
        if (this.fontList == null || this.cbBold == null || this.cbItalic == null || this.sizeList == null || this.sizeList.getSelectedValue() == null) {
            return new PhetFont(0, 12);
        }
        String string = (String)this.fontList.getSelectedValue();
        int n = Integer.parseInt((String)this.sizeList.getSelectedValue());
        int n2 = 0;
        if (this.cbBold.isSelected()) {
            ++n2;
        }
        if (this.cbItalic.isSelected()) {
            n2 += 2;
        }
        return new Font(string, n2, n);
    }

    public static interface Listener {
        public void fontChanged(Font var1);
    }
}

