/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.persistence;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QuantumWaveInterferenceApplication;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.FractionalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.RectangularObject;
import edu.colorado.phet.quantumwaveinterference.model.potentials.CompositePotential;
import edu.colorado.phet.quantumwaveinterference.model.potentials.RectangularPotential;
import edu.colorado.phet.quantumwaveinterference.modules.single.SingleParticleModule;
import edu.colorado.phet.quantumwaveinterference.persistence.PersistenceManager;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangularPotentialGraphic;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;

public class QWIState
implements IProguardKeepClass,
Serializable {
    private ArrayList detectorList = new ArrayList();
    private ArrayList rectBarrierList = new ArrayList();
    private DoubleSlitState doubleSlitState;
    private boolean doubleSlitEnabled;

    public QWIState() {
    }

    public boolean equals(Object object) {
        if (object instanceof QWIState) {
            QWIState qWIState = (QWIState)object;
            return this.detectorList.equals(qWIState.detectorList) && this.rectBarrierList.equals(qWIState.rectBarrierList) && this.doubleSlitState.equals(qWIState.doubleSlitState) && this.doubleSlitEnabled == qWIState.doubleSlitEnabled;
        }
        return false;
    }

    public QWIState(QWIModule qWIModule) {
        for (int i = 0; i < qWIModule.getQWIModel().getDetectorSet().numDetectors(); ++i) {
            Detector detector = qWIModule.getQWIModel().getDetectorSet().detectorAt(i);
            this.detectorList.add(new DetectorState(detector));
        }
        CompositePotential compositePotential = qWIModule.getQWIModel().getCompositePotential();
        for (int i = 0; i < compositePotential.numPotentials(); ++i) {
            Potential potential = compositePotential.potentialAt(i);
            if (!(potential instanceof RectangularPotential)) continue;
            this.rectBarrierList.add(new RectBarrierState((RectangularPotential)potential));
        }
        this.doubleSlitState = new DoubleSlitState(qWIModule.getQWIModel().getFractionalDoubleSlit());
        this.doubleSlitEnabled = qWIModule.getQWIModel().isDoubleSlitEnabled();
    }

    public DoubleSlitState getDoubleSlitState() {
        return this.doubleSlitState;
    }

    public void setDoubleSlitState(DoubleSlitState doubleSlitState) {
        this.doubleSlitState = doubleSlitState;
    }

    public boolean isDoubleSlitEnabled() {
        return this.doubleSlitEnabled;
    }

    public void setDoubleSlitEnabled(boolean bl) {
        this.doubleSlitEnabled = bl;
    }

    public ArrayList getDetectorList() {
        return this.detectorList;
    }

    public void setDetectorList(ArrayList arrayList) {
        this.detectorList = arrayList;
    }

    public ArrayList getRectBarrierList() {
        return this.rectBarrierList;
    }

    public void setRectBarrierList(ArrayList arrayList) {
        this.rectBarrierList = arrayList;
    }

    public String toString() {
        return super.toString() + ", det" + this.detectorList + ", pot=" + this.rectBarrierList;
    }

    public void restore(QWIModule qWIModule) {
        RectangularObject rectangularObject;
        SerializableRect serializableRect;
        int n;
        qWIModule.getQWIModel().setDoubleSlitEnabled(false);
        qWIModule.removeAllDetectors();
        qWIModule.removeAllPotentialBarriers();
        for (n = 0; n < this.detectorList.size(); ++n) {
            serializableRect = (DetectorState)this.detectorList.get(n);
            rectangularObject = new Detector(qWIModule.getQWIModel(), serializableRect.getX(), serializableRect.getY(), serializableRect.getWidth(), serializableRect.getHeight());
            qWIModule.getQWIModel().addDetector((Detector)rectangularObject);
            qWIModule.getSchrodingerPanel().addDetectorGraphic((Detector)rectangularObject);
        }
        for (n = 0; n < this.rectBarrierList.size(); ++n) {
            serializableRect = (RectBarrierState)this.rectBarrierList.get(n);
            rectangularObject = new RectangularPotential(qWIModule.getQWIModel(), serializableRect.getX(), serializableRect.getY(), serializableRect.getWidth(), serializableRect.getHeight());
            qWIModule.getSchrodingerPanel().addRectangularPotentialGraphic(new RectangularPotentialGraphic(qWIModule.getSchrodingerPanel(), (RectangularPotential)rectangularObject));
            qWIModule.getQWIModel().addPotential((Potential)((Object)rectangularObject));
        }
        this.doubleSlitState.restore(qWIModule.getQWIModel().getFractionalDoubleSlit());
        qWIModule.getQWIModel().setDoubleSlitEnabled(this.doubleSlitEnabled);
    }

    public static void main(String[] stringArray) throws Exception {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new QuantumWaveInterferenceApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "quantum-wave-interference", "quantum-wave-interference");
        QuantumWaveInterferenceApplication quantumWaveInterferenceApplication = (QuantumWaveInterferenceApplication)applicationConstructor.getApplication(phetApplicationConfig);
        PersistenceManager persistenceManager = new PersistenceManager(new JButton());
        SingleParticleModule singleParticleModule = new SingleParticleModule(quantumWaveInterferenceApplication, (IClock)new SwingClock(30, 1.0));
        singleParticleModule.getQWIModel().addDetector(new Detector(singleParticleModule.getQWIModel(), 5, 6, 7, 8));
        singleParticleModule.getQWIModel().addDetector(new Detector(singleParticleModule.getQWIModel(), 1, 1, 2, 2));
        singleParticleModule.getQWIModel().addPotential(new RectangularPotential(singleParticleModule.getQWIModel(), 0, 0, 100, 100));
        singleParticleModule.getQWIModel().addPotential(new RectangularPotential(singleParticleModule.getQWIModel(), 9, 9, 9, 9));
        Object object = persistenceManager.load();
        System.out.println("o = " + object);
        System.exit(0);
    }

    public static class DetectorState
    extends SerializableRect {
        public DetectorState() {
        }

        public DetectorState(Detector detector) {
            super(new Rectangle(detector.getBounds()));
        }
    }

    public static class DoubleSlitState
    implements IProguardKeepClass {
        private double height;
        private double separation;
        private double size;
        private double y;

        public DoubleSlitState() {
        }

        public boolean equals(Object object) {
            if (object instanceof DoubleSlitState) {
                DoubleSlitState doubleSlitState = (DoubleSlitState)object;
                return this.height == doubleSlitState.height && this.separation == doubleSlitState.separation && this.size == doubleSlitState.size && this.y == doubleSlitState.y;
            }
            return false;
        }

        public DoubleSlitState(FractionalDoubleSlit fractionalDoubleSlit) {
            this.height = fractionalDoubleSlit.getHeight();
            this.separation = fractionalDoubleSlit.getSlitSeparation();
            this.size = fractionalDoubleSlit.getSlitSize();
            this.y = fractionalDoubleSlit.getY();
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        public double getSeparation() {
            return this.separation;
        }

        public void setSeparation(double d) {
            this.separation = d;
        }

        public double getSize() {
            return this.size;
        }

        public void setSize(double d) {
            this.size = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public void restore(FractionalDoubleSlit fractionalDoubleSlit) {
            fractionalDoubleSlit.setHeight(this.height);
            fractionalDoubleSlit.setSlitSeparation(this.separation);
            fractionalDoubleSlit.setSlitSize(this.size);
            fractionalDoubleSlit.setY(this.y);
        }
    }

    public static class RectBarrierState
    extends SerializableRect {
        public RectBarrierState() {
        }

        public RectBarrierState(RectangularPotential rectangularPotential) {
            super(new Rectangle(rectangularPotential.getBounds()));
        }
    }

    public static class SerializableRect
    implements IProguardKeepClass {
        private int x;
        private int y;
        private int width;
        private int height;

        public SerializableRect() {
        }

        public SerializableRect(Rectangle rectangle) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = rectangle.width;
            this.height = rectangle.height;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }
    }
}

