/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityBeamPanel;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelGun;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelGunSet;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelModule;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelSchrodingerScreenNode;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelSplitColorMap;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.PhotonColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityGunNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.QWIScreenNode;
import java.awt.Color;

public class MandelSchrodingerPanel
extends IntensityBeamPanel {
    private MandelModule mandelModule;

    public MandelSchrodingerPanel(MandelModule mandelModule) {
        super(mandelModule);
        this.mandelModule = mandelModule;
    }

    protected QWIScreenNode createSchrodingerScreenNode(QWIModule qWIModule) {
        return new MandelSchrodingerScreenNode((MandelModule)qWIModule, (QWIPanel)this);
    }

    protected void doAddGunControlPanel() {
    }

    protected MandelModule getMandelModule() {
        return this.mandelModule;
    }

    protected IntensityGunNode createGun() {
        return new MandelGunSet(this);
    }

    protected boolean useGunChooserGraphic() {
        return false;
    }

    public MandelGun getLeftGun() {
        return this.getGunSet().getLeftGun();
    }

    public MandelGun getRightGun() {
        return this.getGunSet().getRightGun();
    }

    private MandelGunSet getGunSet() {
        return (MandelGunSet)this.getGunGraphic();
    }

    public void wavelengthChanged() {
        this.getWavefunctionGraphic().setColorMap(new MandelSplitColorMap(this.getMandelModule(), this.createAccessor()));
        this.updateDetectorColors();
    }

    public void updateDetectorColors() {
        VisibleColor visibleColor = new VisibleColor(this.getLeftGun().getWavelength());
        VisibleColor visibleColor2 = new VisibleColor(this.getRightGun().getWavelength());
        Color color = Color.white;
        this.getContinuousDisplay().setPhotonColor(new ColorData(color));
        this.getDetectorSheetPNode().setDisplayPhotonColor(new ColorData(color));
    }

    public MandelGunSet getMandelGunSet() {
        return this.getGunSet();
    }

    protected ColorMap createColorMap() {
        if (this.getMandelModule() == null || this.getMandelModule().getMandelModel() == null) {
            return new PhotonColorMap(this, 0.0, this.createAccessor());
        }
        if (this.getMandelModule().getMandelModel().isSplit()) {
            return new MandelSplitColorMap(this.mandelModule, this.createAccessor());
        }
        return new PhotonColorMap(this, (this.getLeftGun().getWavelength() + this.getRightGun().getWavelength()) / 2.0, this.createAccessor());
    }

    private WaveValueAccessor createAccessor() {
        return new WaveValueAccessor.Magnitude();
    }
}

