/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.QuantumWaveInterferenceApplication;
import edu.colorado.phet.quantumwaveinterference.model.WaveModel;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelControlPanel;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelGun;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelModel;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelSchrodingerPanel;
import java.util.ArrayList;

public class MandelModule
extends QWIModule {
    private MandelModel splitModel;
    private MandelSchrodingerPanel mandelSchrodingerPanel;
    private MandelControlPanel intensityControlPanel;
    private ArrayList listeners = new ArrayList();

    public MandelModule(QuantumWaveInterferenceApplication quantumWaveInterferenceApplication, IClock iClock) {
        super(QWIResources.getString("module.lasers"), quantumWaveInterferenceApplication, iClock);
        this.splitModel = new MandelModel();
        this.setQWIModel(this.splitModel);
        this.mandelSchrodingerPanel = new MandelSchrodingerPanel(this);
        this.setSchrodingerPanel(this.mandelSchrodingerPanel);
        this.intensityControlPanel = new MandelControlPanel(this);
        this.setSchrodingerControlPanel(this.intensityControlPanel);
        this.finishInit();
        MandelGun.Listener listener = new MandelGun.Listener(){

            public void wavelengthChanged() {
                MandelModule.this.clearWaves();
                MandelModule.this.mandelSchrodingerPanel.wavelengthChanged();
                MandelModule.this.mandelSchrodingerPanel.updateDetectorColors();
                MandelModule.this.synchronizeModel();
            }

            public void intensityChanged() {
                MandelModule.this.synchronizeModel();
                MandelModule.this.mandelSchrodingerPanel.updateDetectorColors();
            }
        };
        this.mandelSchrodingerPanel.updateDetectorColors();
        this.getLeftGun().addListener(listener);
        this.getRightGun().addListener(listener);
        this.synchronizeModel();
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 1.0, 380.0, 780.0);
        this.getLeftGun().setWavelength(linearFunction.evaluate(0.25));
        this.getRightGun().setWavelength(linearFunction.evaluate(0.6666666666666666));
    }

    private void clearWaves() {
        this.getSplitModel().clearAllWaves();
    }

    public MandelModel getSplitModel() {
        return this.splitModel;
    }

    public MandelSchrodingerPanel getMandelSchrodingerPanel() {
        return this.mandelSchrodingerPanel;
    }

    public MandelModel getMandelModel() {
        return this.splitModel;
    }

    private double getWavefunctionDifference() {
        return Math.abs(this.getLeftGun().getWavelength() - this.getRightGun().getWavelength());
    }

    private MandelGun getLeftGun() {
        return this.mandelSchrodingerPanel.getLeftGun();
    }

    private MandelGun getRightGun() {
        return this.mandelSchrodingerPanel.getRightGun();
    }

    private void synchronizeModel() {
        if (this.getWavefunctionDifference() < 10.0) {
            this.setSplitModel(false);
            BeamParam beamParam = new BeamParam(this.getLeftGun().getWavelength(), this.getLeftGun().getIntensity(), this.splitModel.getWaveModel());
            BeamParam beamParam2 = new BeamParam(this.getLeftGun().getWavelength(), this.getRightGun().getIntensity(), this.splitModel.getWaveModel());
            this.mandelSchrodingerPanel.getMandelGunSet().setBeamParameters(beamParam, beamParam2);
        } else {
            this.setSplitModel(true);
            BeamParam beamParam = new BeamParam(this.getLeftGun().getWavelength(), this.getLeftGun().getIntensity(), this.splitModel.getLeftWaveModel());
            BeamParam beamParam3 = new BeamParam(this.getRightGun().getWavelength(), this.getRightGun().getIntensity(), this.splitModel.getRightWaveModel());
            this.mandelSchrodingerPanel.getMandelGunSet().setBeamParameters(beamParam, beamParam3);
        }
    }

    private void setSplitModel(boolean bl) {
        this.splitModel.setSplitMode(bl);
        this.mandelSchrodingerPanel.setSplitMode(bl);
    }

    public static class BeamParam {
        double momentum;
        double intensity;
        WaveModel wavefunction;

        public BeamParam(double d, double d2, WaveModel waveModel) {
            this.momentum = d;
            this.intensity = d2;
            this.wavefunction = waveModel;
        }

        public double getMomentum() {
            return this.momentum;
        }

        public double getIntensity() {
            return this.intensity;
        }

        public WaveModel getWaveModel() {
            return this.wavefunction;
        }

        public String toString() {
            return "wavelength=" + this.momentum + ", intensity=" + this.intensity + ", wavefunction=" + this.wavefunction;
        }

        public void setMomentum(double d) {
            this.momentum = d;
        }
    }
}

