/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.propagators;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveDebugger;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.VisualColorMap3;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplitOperatorPropagator
extends Propagator {
    private double scale = 0.004;
    private WaveDebugger momentumDisplay;
    private Wavefunction expT = null;
    private Wavefunction expV = null;
    private Wavefunction temp = null;
    private QWIModel QWIModel;
    static boolean displayMomentumWavefunction = false;

    public SplitOperatorPropagator(QWIModel qWIModel, Potential potential) {
        super(potential);
        this.QWIModel = qWIModel;
        if (qWIModel != null) {
            qWIModel.addListener(new QWIModel.Adapter(){

                public void potentialChanged() {
                    SplitOperatorPropagator.this.updateExpV();
                }
            });
        }
    }

    public void activate() {
        super.activate();
        this.addDebugControls();
    }

    public void deactivate() {
        super.deactivate();
    }

    private void addDebugControls() {
        JFrame jFrame = new JFrame(QWIResources.getString("som.controls"));
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        DecimalFormat decimalFormat = new DecimalFormat("0.0000000");
        final ModelSlider modelSlider = new ModelSlider(QWIResources.getString("scale"), QWIResources.getString("1.p.2"), 0.0, 0.1, this.scale, decimalFormat);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SplitOperatorPropagator.this.setScale(modelSlider.getValue());
            }
        });
        verticalLayoutPanel.add(modelSlider);
        final JCheckBox jCheckBox = new JCheckBox(QWIResources.getString("show.momenta"));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                displayMomentumWavefunction = jCheckBox.isSelected();
            }
        });
        verticalLayoutPanel.add(jCheckBox);
        jFrame.setContentPane(verticalLayoutPanel);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        this.initMomentumDisplay();
    }

    private void initMomentumDisplay() {
        this.momentumDisplay = new WaveDebugger(QWIResources.getString("wave"), new Wavefunction(50, 50), 3, 3);
        this.momentumDisplay.setComplexColorMap(new VisualColorMap3());
        this.momentumDisplay.setVisible(true);
    }

    private void setScale(double d) {
        this.scale = d;
        this.expT = null;
    }

    public void propagate(Wavefunction wavefunction) {
        throw new RuntimeException("QWIFFT2D not defined (see opensourcephysics dependence)");
    }

    private void updateExpV() {
        this.expV = null;
    }

    public void reset() {
    }

    public Propagator copy() {
        return new SplitOperatorPropagator(this.QWIModel, this.getPotential());
    }

    public void setWavefunctionNorm(double d) {
    }

    public void setValue(int n, int n2, double d, double d2) {
    }
}

