/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.propagators;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;

public class CrankNicholsonPropagator
extends Propagator {
    private double simulationTime;
    private double deltaTime;
    private int timeStep;
    private static final Complex TWO = new Complex(2.0, 0.0);
    private static final Complex MINUS_ONE = new Complex(-1.0, 0.0);
    private Wave wave;

    public CrankNicholsonPropagator(double d, Wave wave, Potential potential) {
        super(potential);
        this.deltaTime = d;
        this.wave = wave;
        this.simulationTime = 0.0;
        this.timeStep = 0;
    }

    private double getPotential(int n, int n2) {
        return this.getPotential().getPotential(n, n2, this.timeStep);
    }

    public void propagate(Wavefunction wavefunction) {
        int n;
        int n2;
        int n3;
        this.simulationTime += this.deltaTime;
        ++this.timeStep;
        int n4 = wavefunction.getWidth() - 1;
        int n5 = wavefunction.getHeight() - 1;
        Complex[] complexArray = new Complex[n4 + n5];
        Complex[] complexArray2 = new Complex[n4 + n5];
        Complex[] complexArray3 = new Complex[n4 + n5];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = new Complex();
            complexArray2[i] = new Complex();
            complexArray3[i] = new Complex();
        }
        Complex complex = new Complex(0.0, -0.5 * (double)n4 * (double)n4 * this.deltaTime);
        Complex complex2 = new Complex();
        Complex complex3 = new Complex(1.0, (double)(n4 * n4) * this.deltaTime);
        Complex complex4 = new Complex(0.0, 0.5 * this.deltaTime);
        Complex complex5 = new Complex(0.0, -0.5 * (double)n5 * (double)n5 * this.deltaTime);
        Complex complex6 = new Complex();
        Complex complex7 = new Complex(1.0, (double)(n5 * n5) * this.deltaTime);
        Complex complex8 = new Complex(0.0, 0.5 * this.deltaTime);
        Complex complex9 = new Complex();
        Complex complex10 = new Complex();
        for (n3 = 1; n3 < n5; ++n3) {
            n2 = n4;
            complexArray[n2 - 1].zero();
            complexArray2[n2 - 1] = this.wave.getValue(n4, n3, this.simulationTime);
            for (n = n2 - 1; n >= 1; --n) {
                complex2 = complex3.plus(complex4.times(this.getPotential(n, n3) / 2.0));
                complex9 = TWO.minus(complex2).times(wavefunction.valueAt(n, n3)).minus(complex.times(wavefunction.valueAt(n - 1, n3).plus(wavefunction.valueAt(n + 1, n3))));
                complexArray3[n] = MINUS_ONE.divideBy(complex2.plus(complex.times(complexArray[n])));
                complexArray[n - 1] = complexArray3[n].times(complex);
                complexArray2[n - 1] = complexArray3[n].times(complex.times(complexArray2[n]).minus(complex9));
            }
            this.fixEdges(wavefunction);
            this.origFixA(wavefunction, n3);
            for (n = 0; n <= n2 - 1; ++n) {
                wavefunction.setValue(n + 1, n3, complexArray[n].times(wavefunction.valueAt(n, n3)).plus(complexArray2[n]));
            }
        }
        this.fixEdges(wavefunction);
        for (n3 = 1; n3 < n4; ++n3) {
            n2 = n5;
            complexArray[n2 - 1].zero();
            complexArray2[n2 - 1] = this.wave.getValue(n3, n5, this.simulationTime);
            for (n = n2 - 1; n >= 1; --n) {
                complex6 = complex7.plus(complex8.times(this.getPotential(n3, n) / 2.0));
                complex10 = TWO.minus(complex6).times(wavefunction.valueAt(n3, n)).minus(complex5.times(wavefunction.valueAt(n3, n - 1).plus(wavefunction.valueAt(n3, n + 1))));
                complexArray3[n] = MINUS_ONE.divideBy(complex6.plus(complex5.times(complexArray[n])));
                complexArray[n - 1] = complexArray3[n].times(complex5);
                complexArray2[n - 1] = complexArray3[n].times(complex5.times(complexArray2[n]).minus(complex10));
            }
            this.fixEdges(wavefunction);
            this.origFixB(wavefunction, n3);
            for (n = 0; n <= n2 - 1; ++n) {
                wavefunction.setValue(n3, n + 1, complexArray[n].times(wavefunction.valueAt(n3, n)).plus(complexArray2[n]));
            }
        }
        this.fixEdges(wavefunction);
    }

    private void origFixB(Wavefunction wavefunction, int n) {
        this.setValue(wavefunction, n, 0);
    }

    private void origFixA(Wavefunction wavefunction, int n) {
        this.setValue(wavefunction, 0, n);
    }

    private void fixEdges(Wavefunction wavefunction) {
    }

    private void setValue(Wavefunction wavefunction, int n, int n2) {
        Complex complex = this.wave.getValue(n, n2, (double)this.timeStep * this.deltaTime);
        wavefunction.setValue(n, n2, complex);
    }

    public void setDeltaTime(double d) {
        this.deltaTime = d;
    }

    public double getSimulationTime() {
        return this.simulationTime;
    }

    public void reset() {
    }

    public Propagator copy() {
        return new CrankNicholsonPropagator(this.deltaTime, this.wave, this.getPotential());
    }

    public void setWavefunctionNorm(double d) {
    }

    public void setValue(int n, int n2, double d, double d2) {
    }
}

