/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.awt.Rectangle;
import java.text.MessageFormat;

public class Wavefunction {
    public Complex[][] wavefunction;
    private double magnitude = 0.0;
    private boolean magnitudeDirty = true;
    private boolean debug = false;

    public void clearRect(Rectangle rectangle) {
        for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y; j < rectangle.y + rectangle.height; ++j) {
                if (!this.containsLocation(i, j)) continue;
                this.setValue(i, j, new Complex());
            }
        }
    }

    public void splitWave(Rectangle rectangle, Wavefunction wavefunction, Wavefunction wavefunction2) {
        for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y; j < rectangle.y + rectangle.height; ++j) {
                Complex complex = this.valueAt(i, j);
                wavefunction.setValue(i, j, complex.times(0.5));
                wavefunction2.setValue(i, j, complex.times(0.5));
            }
        }
    }

    public void combineWaves(Rectangle rectangle, Wavefunction wavefunction, Wavefunction wavefunction2) {
        for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y; j < rectangle.y + rectangle.height; ++j) {
                double d = 1.0;
                this.setValue(i, j, (wavefunction.valueAt(i, j).getReal() + wavefunction2.valueAt(i, j).getReal()) / d, (wavefunction.valueAt(i, j).getImaginary() + wavefunction2.valueAt(i, j).getImaginary()) / d);
            }
        }
    }

    public Wavefunction(int n, int n2) {
        this.wavefunction = new Complex[n][n2];
        this.clear();
    }

    public Wavefunction(Complex[][] complexArray) {
        this.wavefunction = complexArray;
        this.setMagnitudeDirty();
    }

    public void setMagnitude(double d) {
        this.setMagnitudeDirty();
        double d2 = this.getMagnitude();
        this.scale(Math.sqrt(d) / Math.sqrt(d2));
        double d3 = this.getMagnitude();
        if (Math.abs(d3 - d) > 1.0E-5) {
            throw new RuntimeException("Normalization failed: requested new magnitude=" + d + ", received=" + d3);
        }
    }

    public void scale(double d) {
        if (d != 1.0) {
            for (int i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < this.getHeight(); ++j) {
                    Complex complex = this.wavefunction[i][j];
                    complex.scale(d);
                }
            }
        }
        this.setMagnitudeDirty();
    }

    public boolean containsLocation(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public void copyTo(Wavefunction wavefunction) {
        wavefunction.setSize(this.getWidth(), this.getHeight());
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                wavefunction.setValue(i, j, this.valueAt(i, j));
            }
        }
        wavefunction.setMagnitudeDirty();
    }

    public int getWidth() {
        return this.wavefunction.length;
    }

    public int getHeight() {
        return this.wavefunction[0].length;
    }

    public void setValue(int n, int n2, double d, double d2) {
        this.wavefunction[n][n2].setValue(d, d2);
    }

    public void setValue(int n, int n2, Complex complex) {
        this.setValue(n, n2, complex.getReal(), complex.getImaginary());
    }

    public Complex valueAt(int n, int n2) {
        return this.wavefunction[n][n2];
    }

    public void normalize() {
        double d = this.getMagnitude();
        double d2 = 1.0 / Math.sqrt(d);
        this.scale(d2);
        double d3 = this.getMagnitude();
        double d4 = 1.0 - d3;
        double d5 = Math.abs(d4);
        if (d5 > 1.0E-4 && this.debug) {
            System.out.println(MessageFormat.format(QWIResources.getString("error.in.probability.normalization.norm.0.err.1"), new Double(d3), new Double(d5)));
        }
        this.setMagnitudeDirty();
    }

    public double getMagnitude() {
        if (this.magnitudeDirty) {
            this.magnitude = this.recomputeMagnitude();
            this.magnitudeDirty = false;
        }
        return this.magnitude;
    }

    private double recomputeMagnitude() {
        Complex complex = new Complex();
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                Complex complex2 = this.wavefunction[i][j].complexConjugate();
                Complex complex3 = this.wavefunction[i][j];
                Complex complex4 = complex2.times(complex3);
                complex = complex.plus(complex4);
            }
        }
        double d = complex.abs();
        return Double.isNaN(d) ? 0.0 : d;
    }

    public void clear() {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                if (this.valueAt(i, j) == null) {
                    this.wavefunction[i][j] = new Complex();
                    continue;
                }
                this.valueAt(i, j).zero();
            }
        }
        this.setMagnitudeDirty();
    }

    public void setMagnitudeDirty() {
        this.magnitudeDirty = true;
    }

    public void setSize(int n, int n2) {
        if (this.getWidth() != n || this.getHeight() != n2) {
            this.wavefunction = new Complex[n][n2];
            this.clear();
        }
    }

    public Wavefunction copy() {
        Complex[][] complexArray = new Complex[this.getWidth()][this.getHeight()];
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                complexArray[i][j] = this.valueAt(i, j).copy();
            }
        }
        return new Wavefunction(complexArray);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getWidth(), this.getHeight());
    }

    public Wavefunction copyRegion(int n, int n2, int n3, int n4) {
        Wavefunction wavefunction = new Wavefunction(n3, n4);
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                wavefunction.wavefunction[i - n][j - n2] = new Complex(this.valueAt(i, j));
            }
        }
        return wavefunction;
    }

    public void add(Wavefunction wavefunction) {
        if (wavefunction.getWidth() == this.getWidth() && wavefunction.getHeight() == this.getHeight()) {
            for (int i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < this.getHeight(); ++j) {
                    this.valueAt(i, j).add(wavefunction.valueAt(i, j));
                }
            }
        } else {
            throw new RuntimeException("illegal arg dim");
        }
        this.setMagnitudeDirty();
    }

    public Wavefunction createEmptyWavefunction() {
        return new Wavefunction(this.getWidth(), this.getHeight());
    }
}

