/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.awt.Rectangle;

public class WaveModel {
    private Wavefunction wavefunction;
    private Propagator propagator;

    public WaveModel(Wavefunction wavefunction, Propagator propagator) {
        this.wavefunction = wavefunction;
        this.propagator = propagator;
    }

    public Wavefunction getWavefunction() {
        return this.wavefunction;
    }

    public Propagator getPropagator() {
        return this.propagator;
    }

    public void setPropagator(Propagator propagator) {
        this.propagator = propagator;
    }

    public void clear() {
        this.wavefunction.clear();
        this.propagator.reset();
    }

    public void setWavefunctionNorm(double d) {
        this.wavefunction.setMagnitude(d);
        this.propagator.setWavefunctionNorm(d);
    }

    public void setWaveSize(int n, int n2) {
        this.wavefunction.setSize(n, n2);
        this.clear();
    }

    public void copyTo(Rectangle rectangle, WaveModel waveModel) {
        for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y; j < rectangle.y + rectangle.height; ++j) {
                if (!this.wavefunction.containsLocation(i, j)) continue;
                this.copyTo(i, j, waveModel);
            }
        }
    }

    public void copyTo(int n, int n2, WaveModel waveModel) {
        Complex complex = this.wavefunction.valueAt(n, n2);
        waveModel.wavefunction.setValue(n, n2, complex);
        this.propagator.copyTo(n, n2, waveModel.propagator);
    }

    public void propagate() {
        this.propagator.propagate(this.wavefunction);
        this.wavefunction.setMagnitudeDirty();
    }

    public void clearWave(Rectangle rectangle) {
        this.wavefunction.clearRect(rectangle);
        this.propagator.clearWave(rectangle);
    }

    public void splitWave(Rectangle rectangle, WaveModel waveModel, WaveModel waveModel2) {
        this.wavefunction.splitWave(rectangle, waveModel.wavefunction, waveModel2.wavefunction);
        this.propagator.splitWave(rectangle, waveModel.propagator, waveModel2.propagator);
    }

    public void combineWaves(Rectangle rectangle, WaveModel waveModel, WaveModel waveModel2) {
        this.wavefunction.combineWaves(rectangle, waveModel.wavefunction, waveModel2.wavefunction);
        this.propagator.combineWaves(rectangle, waveModel.propagator, waveModel2.propagator);
    }

    public int getWidth() {
        return this.wavefunction.getWidth();
    }

    public int getHeight() {
        return this.wavefunction.getHeight();
    }

    public void setValue(int n, int n2, double d, double d2) {
        this.wavefunction.setValue(n, n2, d, d2);
        this.propagator.setValue(n, n2, d, d2);
    }

    public void setMagnitude(double d) {
        this.wavefunction.setMagnitude(d);
        this.propagator.setWavefunctionNorm(d);
    }

    public boolean containsLocation(int n, int n2) {
        return this.wavefunction.containsLocation(n, n2);
    }

    public void debugSymmetry() {
        System.out.println("Wave size, w=" + this.getWidth() + "h=" + this.getHeight());
    }
}

