/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ParticleUnits {
    private Value hbar;
    private Value mass;
    private Value dx;
    private Value dt;
    private Value minVelocity;
    private Value maxVelocity;
    private int numRulerReadings;
    private DecimalFormat rulerFormat;
    private double rulerWidth;
    private double latticeWidth;
    private double timeScaleFactor = 1.0;
    private static double scaleDownMaxVel = 0.5;
    private static double scaleMinVel = 0.5;

    protected ParticleUnits() {
    }

    public String toString() {
        return "hbar=" + this.hbar + ", mass=" + this.mass + ", dx=" + this.dx + ", dt=" + this.dt + ", minVelocity=" + this.minVelocity + ", maxVelocity=" + this.maxVelocity;
    }

    public Value getHbar() {
        return this.hbar;
    }

    public void setHbar(Value value) {
        this.hbar = value;
    }

    public Value getMass() {
        return this.mass;
    }

    public void setMass(Value value) {
        this.mass = value;
    }

    public Value getDx() {
        return this.dx;
    }

    public void setDx(Value value) {
        this.dx = value;
    }

    public Value getDt() {
        return this.dt;
    }

    public void setDt(Value value) {
        this.dt = value;
    }

    public Value getMinVelocity() {
        return this.minVelocity;
    }

    public void setMinVelocity(Value value) {
        this.minVelocity = value;
    }

    public Value getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(Value value) {
        this.maxVelocity = value;
    }

    public int getNumRulerReadings() {
        return this.numRulerReadings;
    }

    public DecimalFormat getRulerFormat() {
        return this.rulerFormat;
    }

    public void setNumRulerReadings(int n) {
        this.numRulerReadings = n;
    }

    public void setRulerFormat(DecimalFormat decimalFormat) {
        this.rulerFormat = decimalFormat;
    }

    public double getRulerWidth() {
        return this.rulerWidth;
    }

    public double getLatticeWidth() {
        return this.latticeWidth;
    }

    protected void setRulerWidth(double d) {
        this.rulerWidth = d;
    }

    protected void setLatticeWidth(double d) {
        this.latticeWidth = d;
    }

    public void setTimeScaleFactor(double d) {
        this.timeScaleFactor = d;
    }

    protected void setVelocityFormat(DecimalFormat decimalFormat) {
        this.getMinVelocity().setDefaultFormat(decimalFormat);
        this.getMaxVelocity().setDefaultFormat(decimalFormat);
    }

    public double getTimeScaleFactor() {
        return this.timeScaleFactor;
    }

    protected void setupLatticeAndRuler() {
        double d = 10.0;
        this.setLatticeWidth(0.45 * d);
        this.setRulerWidth(0.5 * d);
        this.setRulerFormat(new DecimalFormat("0.0"));
        this.setNumRulerReadings(6);
    }

    public static class ElectronUnits
    extends ParticleUnits {
        public ElectronUnits() {
            this.setHbar(new Value(0.658, 1.0, QWIResources.getString("ev.fs")));
            this.setMass(new Value(0.057, 100.0, QWIResources.getString("ev.fs.2.nm.2")));
            this.setDx(new Value(1.0, 0.1, QWIResources.getString("nm")));
            this.setDt(new Value(0.05, 0.1, QWIResources.getString("fs")));
            double d = 100.0;
            this.setMinVelocity(new Value(700.0 / d, d, QWIResources.getString("gun.km-s")));
            this.setMaxVelocity(new Value(1500.0 / d, d, QWIResources.getString("gun.km-s")));
            DecimalFormat decimalFormat = new DecimalFormat("0");
            this.setVelocityFormat(decimalFormat);
            this.setTimeScaleFactor(10.0);
        }
    }

    public static class HeliumUnits
    extends ParticleUnits {
        public HeliumUnits() {
            this.setHbar(new Value(6.58E-4, 1.0, QWIResources.getString("ev.ps")));
            this.setDx(new Value(1.0, 0.1, QWIResources.getString("nm")));
            this.setDt(new Value(0.5, 0.1, QWIResources.getString("ps")));
            this.setMass(new Value(4.14741E-4, 1.0E-4, QWIResources.getString("ev.fs.2.nm.2")));
            double d = 0.1;
            this.setMinVelocity(new Value(0.1 / d, d, QWIResources.getString("gun.km-s")));
            this.setMaxVelocity(new Value(0.2 / d, d, QWIResources.getString("gun.km-s")));
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            this.setVelocityFormat(decimalFormat);
            this.setupLatticeAndRuler();
            this.setTimeScaleFactor(10.0);
        }
    }

    public static class NeutronUnits
    extends ParticleUnits {
        public NeutronUnits() {
            this.setHbar(new Value(6.58E-4, 1.0, QWIResources.getString("ev.ps")));
            this.setDx(new Value(1.0, 0.1, QWIResources.getString("nm")));
            this.setDt(new Value(0.1, 0.1, QWIResources.getString("ps")));
            this.setMass(new Value(1.04539E-4, 1.0E-4, QWIResources.getString("ev.fs.2.nm.2")));
            double d = 0.1;
            this.setMinVelocity(new Value(0.4 / d, d, QWIResources.getString("gun.km-s")));
            this.setMaxVelocity(new Value(0.8 / d, d, QWIResources.getString("gun.km-s")));
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            this.setVelocityFormat(decimalFormat);
            this.setupLatticeAndRuler();
            this.setTimeScaleFactor(10.0);
        }
    }

    public static class PhotonUnits
    extends ParticleUnits {
        public PhotonUnits() {
            this.setDx(new Value(1.0, 1200.0, QWIResources.getString("nm")));
            this.setDt(new Value(1.0, 0.1, QWIResources.getString("fs")));
            this.setLatticeWidth(2700.0);
            this.setRulerWidth(3000.0);
            this.setRulerFormat(new DecimalFormat("0"));
            this.setNumRulerReadings(4);
        }
    }

    public static class Value {
        double value;
        double displayScaleFactor;
        String units;
        private NumberFormat defaultFormat;

        public Value(double d, double d2, String string) {
            this.value = d;
            this.displayScaleFactor = d2;
            this.units = string;
        }

        public void setDefaultFormat(NumberFormat numberFormat) {
            this.defaultFormat = numberFormat;
        }

        public double getValue() {
            return this.value;
        }

        public double getDisplayValue() {
            return this.value * this.displayScaleFactor;
        }

        public String getUnits() {
            return this.units;
        }

        public String toString() {
            return "" + this.getDisplayValue() + " " + this.units + " [@" + this.value + "]";
        }

        public String toPrettyString(NumberFormat numberFormat) {
            return numberFormat.format(this.getDisplayValue()) + " " + this.units;
        }

        public String toPrettyString() {
            return this.toPrettyString(this.defaultFormat);
        }
    }
}

