/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.QWIModel;

public class FractionalDoubleSlit {
    private QWIModel qwiModel;
    private double y;
    private double height;
    private double slitSize;
    private double slitSeparation;
    private double potential;

    public FractionalDoubleSlit(QWIModel qWIModel, double d, double d2, double d3, double d4) {
        this.qwiModel = qWIModel;
        this.y = d;
        this.height = d2;
        this.slitSize = d3;
        this.slitSeparation = d4;
        this.update();
        qWIModel.addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                FractionalDoubleSlit.this.update();
            }
        });
    }

    public void reset(double d, double d2, double d3, double d4, double d5) {
        this.y = d;
        this.height = d2;
        this.slitSize = d3;
        this.slitSeparation = d4;
        this.potential = d5;
        this.update();
    }

    private void update() {
        this.qwiModel.getDoubleSlitPotential().setGridWidth(this.qwiModel.getGridWidth());
        this.qwiModel.getDoubleSlitPotential().setGridHeight(this.qwiModel.getGridHeight());
        this.qwiModel.getDoubleSlitPotential().setHeight(this.round(this.height * (double)this.qwiModel.getGridHeight()));
        int n = this.roundEven(this.slitSize * (double)this.qwiModel.getGridWidth());
        this.qwiModel.getDoubleSlitPotential().setSlitWidth(n);
        this.qwiModel.getDoubleSlitPotential().setY(this.round(this.y * (double)this.qwiModel.getGridHeight()));
        int n2 = (int)((double)this.qwiModel.getGridWidth() * this.slitSeparation - (double)n);
        this.qwiModel.getDoubleSlitPotential().setNumCellsBetweenSlits(n2);
    }

    private int roundEven(double d) {
        int n = this.round(d);
        if (n % 2 == 0) {
            ++n;
        }
        return n;
    }

    private int round(double d) {
        return (int)d;
    }

    public void setY(double d) {
        this.y = d;
        this.update();
    }

    public void setHeight(double d) {
        this.height = d;
        this.update();
    }

    public void setSlitSize(double d) {
        this.slitSize = d;
        this.update();
    }

    public void setSlitSeparation(double d) {
        this.slitSeparation = d;
        this.update();
    }

    public double getY() {
        return this.y;
    }

    public double getHeight() {
        return this.height;
    }

    public double getSlitSize() {
        return this.slitSize;
    }

    public double getSlitSeparation() {
        return this.slitSeparation;
    }

    public double getPotential() {
        return this.potential;
    }
}

