/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Random;

public class CollapseComputation {
    private static Random random = new Random();

    public Point getCollapsePoint(Wavefunction wavefunction, Rectangle rectangle) {
        Wavefunction wavefunction2 = wavefunction.copy();
        for (int i = 0; i < wavefunction2.getWidth(); ++i) {
            for (int j = 0; j < wavefunction2.getHeight(); ++j) {
                if (rectangle.contains(i, j)) continue;
                wavefunction2.valueAt(i, j).zero();
            }
        }
        wavefunction2.normalize();
        Complex complex = new Complex();
        double d = random.nextDouble();
        for (int i = 0; i < wavefunction2.getWidth(); ++i) {
            for (int j = 0; j < wavefunction2.getHeight(); ++j) {
                Complex complex2 = wavefunction2.valueAt(i, j).complexConjugate();
                Complex complex3 = wavefunction2.valueAt(i, j);
                Complex complex4 = complex2.times(complex3);
                double d2 = complex.abs();
                complex = complex.plus(complex4);
                double d3 = complex.abs();
                if (!(d2 <= d) || !(d <= d3)) continue;
                return new Point(i, j);
            }
        }
        new RuntimeException("No collapse point.").printStackTrace();
        return new Point(0, 0);
    }
}

