/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.davissongermer.DGIntensityReader;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import java.awt.Point;

public class RadialIntensityReader
implements DGIntensityReader {
    private DGModel dgModel;

    public RadialIntensityReader(DGModel dGModel) {
        this.dgModel = dGModel;
    }

    public double getIntensity(double d) {
        Point point = this.dgModel.getCenterAtomPoint();
        int n = this.getRadius();
        double d2 = (double)n * Math.cos(Math.toRadians(d));
        double d3 = (double)n * Math.sin(Math.toRadians(d));
        Point point2 = new Point((int)((double)point.x + d3), (int)((double)point.y + d2));
        if (this.getWavefunction().containsLocation(point2.x, point2.y)) {
            return this.getWavefunction().valueAt(point2.x, point2.y).abs();
        }
        return 0.0;
    }

    private int getRadius() {
        return this.getWavefunction().getWidth() / 2 - 5;
    }

    private Wavefunction getWavefunction() {
        return this.dgModel.getWavefunction();
    }
}

