/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import java.awt.Point;
import java.awt.geom.Point2D;

public abstract class AtomPotential
implements Potential {
    private Point center;
    private double potentialValue;
    private int diameter;

    public AtomPotential(Point point, int n, double d) {
        this.center = point;
        this.diameter = n;
        this.potentialValue = d;
    }

    public double getPotential(int n, int n2, int n3) {
        Point point = new Point(n, n2);
        if (this.inRange(point)) {
            return this.getPotentialValue();
        }
        return 0.0;
    }

    protected abstract boolean inRange(Point var1);

    private double getPotentialValue() {
        return this.potentialValue;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public String toString() {
        return this.getClass().getName() + ", center=" + this.center + ", diameter=" + this.diameter;
    }
}

