/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ConnectorNode
extends PPath {
    private PNode source;
    private PNode destination;
    private BufferedImage txtr;

    public ConnectorNode(PNode pNode, PNode pNode2) {
        this.source = pNode;
        this.destination = pNode2;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ConnectorNode.this.update();
            }
        };
        pNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        pNode2.addPropertyChangeListener("fullBounds", propertyChangeListener);
        this.update();
        this.setStrokePaint(Color.black);
    }

    public void update() {
        this.connectRectsWithLine();
    }

    public void connectRectsWithLine() {
        if (this.source == null || this.source.getFullBounds() == null || this.destination == null || this.destination.getFullBounds() == null || this.source.getParent() == null || this.destination.getParent() == null) {
            return;
        }
        Point2D point2D = this.source.getGlobalFullBounds().getCenter2D();
        Point2D point2D2 = this.destination.getGlobalFullBounds().getCenter2D();
        this.globalToLocal(point2D);
        this.globalToLocal(point2D2);
        this.updateShape(point2D, point2D2);
        if (this.txtr != null) {
            this.updateTxtr();
        }
        this.repaint();
    }

    protected void updateShape(Point2D point2D, Point2D point2D2) {
        this.setPathTo(new Line2D.Double(point2D, point2D2));
    }

    public void setTexture(BufferedImage bufferedImage) {
        this.txtr = bufferedImage;
        this.updateTxtr();
    }

    private void updateTxtr() {
        this.setPaint(new TexturePaint(this.txtr, new Rectangle2D.Double(this.getFullBounds().getX(), this.getFullBounds().getY(), this.txtr.getWidth(), this.txtr.getHeight())));
    }
}

