/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class BoundedDragHandler
extends PBasicInputEventHandler {
    private PNode dragNode;
    private PNode boundingNode;
    private Point2D relativeClickPoint;

    public BoundedDragHandler(PNode pNode, PNode pNode2) {
        this.dragNode = pNode;
        this.boundingNode = pNode2;
    }

    public void mousePressed(PInputEvent pInputEvent) {
        super.mousePressed(pInputEvent);
        if (this.boundingNode.getRoot() == null) {
            throw new IllegalStateException("boundingNode has no root node. Did you forget to add boundingNode to the scenegraph?");
        }
        this.setRelativeClickPoint(pInputEvent);
    }

    private void setRelativeClickPoint(PInputEvent pInputEvent) {
        Point2D point2D = this.dragNode.getGlobalTranslation();
        Point2D point2D2 = this.getGlobalClickPoint(pInputEvent);
        this.relativeClickPoint = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    private Point2D getGlobalClickPoint(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode);
        this.dragNode.localToGlobal(point2D);
        return point2D;
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        super.mouseDragged(pInputEvent);
        if (this.relativeClickPoint == null) {
            this.setRelativeClickPoint(pInputEvent);
        } else {
            PNode pNode = this.dragNode;
            Point2D point2D = this.getGlobalClickPoint(pInputEvent);
            Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.relativeClickPoint.getX(), point2D.getY() - this.relativeClickPoint.getY());
            pNode.setGlobalTranslation(double_);
            if (!this.boundingNode.getGlobalFullBounds().contains(this.dragNode.getGlobalFullBounds())) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5 = pNode.getGlobalTranslation().getX();
                double d6 = pNode.getGlobalTranslation().getY();
                double d7 = 1.0;
                if (pNode.getGlobalFullBounds().getX() < this.boundingNode.getGlobalFullBounds().getX()) {
                    d4 = pNode.getGlobalTranslation().getX();
                    d3 = pNode.getGlobalFullBounds().getMinX();
                    pNode.setGlobalTranslation(new Point2D.Double(pNode.getGlobalTranslation().getX() - d7, pNode.getGlobalTranslation().getY()));
                    d2 = pNode.getGlobalTranslation().getX();
                    d = pNode.getGlobalFullBounds().getMinX();
                    d5 = this.fitLinear(d4, d3, d2, d, this.boundingNode.getGlobalFullBounds().getMinX());
                }
                if (pNode.getGlobalFullBounds().getY() < this.boundingNode.getGlobalFullBounds().getY()) {
                    d4 = pNode.getGlobalTranslation().getY();
                    d3 = pNode.getGlobalFullBounds().getMinY();
                    pNode.setGlobalTranslation(new Point2D.Double(pNode.getGlobalTranslation().getX(), pNode.getGlobalTranslation().getY() - d7));
                    d2 = pNode.getGlobalTranslation().getY();
                    d = pNode.getGlobalFullBounds().getMinY();
                    d6 = this.fitLinear(d4, d3, d2, d, this.boundingNode.getGlobalFullBounds().getMinY());
                }
                if (pNode.getGlobalFullBounds().getMaxX() > this.boundingNode.getGlobalFullBounds().getMaxX()) {
                    d4 = pNode.getGlobalTranslation().getX();
                    d3 = pNode.getGlobalFullBounds().getMaxX();
                    pNode.setGlobalTranslation(new Point2D.Double(pNode.getGlobalTranslation().getX() - d7, pNode.getGlobalTranslation().getY()));
                    d2 = pNode.getGlobalTranslation().getX();
                    d = pNode.getGlobalFullBounds().getMaxX();
                    d5 = this.fitLinear(d4, d3, d2, d, this.boundingNode.getGlobalFullBounds().getMaxX());
                }
                if (pNode.getGlobalFullBounds().getMaxY() > this.boundingNode.getGlobalFullBounds().getMaxY()) {
                    d4 = pNode.getGlobalTranslation().getY();
                    d3 = pNode.getGlobalFullBounds().getMaxY();
                    pNode.setGlobalTranslation(new Point2D.Double(pNode.getGlobalTranslation().getX(), pNode.getGlobalTranslation().getY() - d7));
                    d2 = pNode.getGlobalTranslation().getY();
                    d = pNode.getGlobalFullBounds().getMaxY();
                    d6 = this.fitLinear(d4, d3, d2, d, this.boundingNode.getGlobalFullBounds().getMaxY());
                }
                Point2D.Double double_2 = new Point2D.Double(d5, d6);
                this.dragNode.setGlobalTranslation(double_2);
            }
        }
    }

    private double fitLinear(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d4) / (d - d3);
        double d7 = d2 - d6 * d;
        return (d5 - d7) / d6;
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        super.mouseReleased(pInputEvent);
        this.relativeClickPoint = null;
    }

    public PNode getBoundingNode() {
        return this.boundingNode;
    }

    public PNode getDragNode() {
        return this.dragNode;
    }
}

