/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.view.EnergyPlot;
import edu.colorado.phet.quantumtunneling.view.PositionAxis;
import edu.colorado.phet.quantumtunneling.view.ProbabilityDensityPlot;
import edu.colorado.phet.quantumtunneling.view.WaveFunctionPlot;
import java.awt.Font;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;

public class QTCombinedChart
extends JFreeChart {
    private static final Font AXIS_LABEL_FONT = new PhetFont(0, 20);
    private static final Font AXIS_TICK_LABEL_FONT = new PhetFont(0, 14);
    private EnergyPlot _energyPlot = new EnergyPlot();
    private WaveFunctionPlot _waveFunctionPlot;
    private ProbabilityDensityPlot _probabilityDensityPlot;

    public QTCombinedChart() {
        super(null, null, new CombinedDomainXYPlot(), false);
        this._energyPlot.setDomainAxis(null);
        this._energyPlot.getRangeAxis().setLabelFont(AXIS_LABEL_FONT);
        this._energyPlot.getRangeAxis().setTickLabelFont(AXIS_TICK_LABEL_FONT);
        Cloneable cloneable = new TickUnits();
        ((TickUnits)cloneable).add(new NumberTickUnit(0.5, QTConstants.ENERGY_TICK_FORMAT));
        this._energyPlot.getRangeAxis().setStandardTickUnits((TickUnitSource)((Object)cloneable));
        this._energyPlot.getRangeAxis().setAutoTickUnitSelection(true);
        this._waveFunctionPlot = new WaveFunctionPlot();
        this._waveFunctionPlot.setDomainAxis(null);
        this._waveFunctionPlot.getRangeAxis().setLabelFont(AXIS_LABEL_FONT);
        this._waveFunctionPlot.getRangeAxis().setTickLabelFont(AXIS_TICK_LABEL_FONT);
        cloneable = this._waveFunctionPlot.getProbabilityDensitySeries();
        this._probabilityDensityPlot = new ProbabilityDensityPlot((XYSeries)cloneable);
        this._probabilityDensityPlot.setDomainAxis(null);
        this._probabilityDensityPlot.getRangeAxis().setLabelFont(AXIS_LABEL_FONT);
        this._probabilityDensityPlot.getRangeAxis().setTickLabelFont(AXIS_TICK_LABEL_FONT);
        cloneable = new PositionAxis();
        ((Axis)cloneable).setLabelFont(AXIS_LABEL_FONT);
        ((Axis)cloneable).setTickLabelFont(AXIS_TICK_LABEL_FONT);
        Cloneable cloneable2 = new TickUnits();
        ((TickUnits)cloneable2).add(new NumberTickUnit(1.0, QTConstants.POSITION_TICK_FORMAT));
        ((ValueAxis)cloneable).setStandardTickUnits((TickUnitSource)((Object)cloneable2));
        ((ValueAxis)cloneable).setAutoTickUnitSelection(true);
        cloneable2 = (CombinedDomainXYPlot)this.getPlot();
        ((XYPlot)cloneable2).setDomainAxis((ValueAxis)cloneable);
        ((CombinedDomainXYPlot)cloneable2).setGap(25.0);
        ((CombinedDomainXYPlot)cloneable2).setOrientation(PlotOrientation.VERTICAL);
        ((CombinedDomainXYPlot)cloneable2).add(this._energyPlot, 1);
        ((CombinedDomainXYPlot)cloneable2).add(this._waveFunctionPlot, 1);
        ((CombinedDomainXYPlot)cloneable2).add(this._probabilityDensityPlot, 1);
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this._energyPlot.setColorScheme(qTColorScheme);
        this._waveFunctionPlot.setColorScheme(qTColorScheme);
        this._probabilityDensityPlot.setColorScheme(qTColorScheme);
    }

    public WaveFunctionPlot getWaveFunctionPlot() {
        return this._waveFunctionPlot;
    }

    public ProbabilityDensityPlot getProbabilityDensityPlot() {
        return this._probabilityDensityPlot;
    }
}

