/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.util;

public class LightweightComplex {
    public double _real;
    public double _imaginary;

    public LightweightComplex() {
        this(0.0, 0.0);
    }

    public LightweightComplex(double d, double d2) {
        this._real = d;
        this._imaginary = d2;
    }

    public double getReal() {
        return this._real;
    }

    public double getImaginary() {
        return this._imaginary;
    }

    public void multiply(LightweightComplex lightweightComplex) {
        double d = this._real * lightweightComplex._real - this._imaginary * lightweightComplex._imaginary;
        double d2 = this._real * lightweightComplex._imaginary + this._imaginary * lightweightComplex._real;
        this._real = d;
        this._imaginary = d2;
    }

    public double getAbs() {
        return Math.sqrt(this._real * this._real + this._imaginary * this._imaginary);
    }

    public double getPhase() {
        return Math.atan2(this._imaginary, this._real);
    }
}

