/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.quantumtunneling.enums.PotentialType;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.BarrierPotential;
import edu.colorado.phet.quantumtunneling.model.ConstantPotential;
import edu.colorado.phet.quantumtunneling.model.DoubleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.SingleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.StepPotential;

public class PotentialFactory {
    public static AbstractPotential createPotentialEnergy(PotentialType potentialType) {
        AbstractPotential abstractPotential;
        if (potentialType == PotentialType.CONSTANT) {
            abstractPotential = new ConstantPotential();
        } else if (potentialType == PotentialType.STEP) {
            abstractPotential = new StepPotential();
        } else if (potentialType == PotentialType.SINGLE_BARRIER) {
            abstractPotential = new SingleBarrierPotential();
        } else if (potentialType == PotentialType.DOUBLE_BARRIER) {
            abstractPotential = new DoubleBarrierPotential();
        } else {
            throw new IllegalStateException("unsupported potentialType: " + potentialType);
        }
        return abstractPotential;
    }

    public static PotentialType getPotentialType(AbstractPotential abstractPotential) {
        PotentialType potentialType = null;
        if (abstractPotential instanceof ConstantPotential) {
            potentialType = PotentialType.CONSTANT;
        } else if (abstractPotential instanceof StepPotential) {
            potentialType = PotentialType.STEP;
        } else if (abstractPotential instanceof SingleBarrierPotential) {
            potentialType = PotentialType.SINGLE_BARRIER;
        } else if (abstractPotential instanceof DoubleBarrierPotential) {
            potentialType = PotentialType.DOUBLE_BARRIER;
        } else {
            throw new IllegalStateException("unsupported potential type: " + abstractPotential.getClass().getName());
        }
        return potentialType;
    }

    public static AbstractPotential clonePotentialEnergy(AbstractPotential abstractPotential) {
        AbstractPotential abstractPotential2 = null;
        if (abstractPotential instanceof ConstantPotential) {
            abstractPotential2 = new ConstantPotential((ConstantPotential)abstractPotential);
        } else if (abstractPotential instanceof StepPotential) {
            abstractPotential2 = new StepPotential((StepPotential)abstractPotential);
        } else if (abstractPotential instanceof SingleBarrierPotential) {
            abstractPotential2 = new SingleBarrierPotential((SingleBarrierPotential)abstractPotential);
        } else if (abstractPotential instanceof BarrierPotential) {
            abstractPotential2 = new DoubleBarrierPotential((DoubleBarrierPotential)abstractPotential);
        } else {
            throw new IllegalStateException("unsupported potential type: " + abstractPotential.getClass().getName());
        }
        return abstractPotential2;
    }
}

