/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.math.MutableComplex;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractBarrierSolver;
import edu.colorado.phet.quantumtunneling.model.BarrierPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;

public class DoubleBarrierSolver
extends AbstractBarrierSolver {
    private MutableComplex _B;
    private MutableComplex _C;
    private MutableComplex _D;
    private MutableComplex _F;
    private MutableComplex _G;
    private MutableComplex _H;
    private MutableComplex _I;
    private MutableComplex _J;

    public DoubleBarrierSolver(TotalEnergy totalEnergy, BarrierPotential barrierPotential, Direction direction) {
        super(totalEnergy, barrierPotential, direction);
        assert (barrierPotential.getNumberOfBarriers() == 2);
    }

    public WaveFunctionSolution solve(double d, double d2) {
        WaveFunctionSolution waveFunctionSolution = null;
        if (this.isSolutionZero()) {
            waveFunctionSolution = new WaveFunctionSolution(d, d2, Complex.ZERO, Complex.ZERO);
        } else {
            int n = this.getPotentialEnergy().getRegionIndexAt(d);
            if (this.isRightToLeft()) {
                n = this.flipRegionIndex(n);
            }
            switch (n) {
                case 0: {
                    waveFunctionSolution = this.solveRegion1(d, d2);
                    break;
                }
                case 1: {
                    waveFunctionSolution = this.solveRegion2(d, d2);
                    break;
                }
                case 2: {
                    waveFunctionSolution = this.solveRegion3(d, d2);
                    break;
                }
                case 3: {
                    waveFunctionSolution = this.solveRegion4(d, d2);
                    break;
                }
                case 4: {
                    waveFunctionSolution = this.solveRegion5(d, d2);
                    break;
                }
                default: {
                    waveFunctionSolution = null;
                }
            }
        }
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion1(double d, double d2) {
        Complex complex = this.getK(0);
        Complex complex2 = DoubleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = DoubleBarrierSolver.commonTerm2(complex, d);
        Complex complex4 = DoubleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = complex2.getMultiply(complex4);
        Complex complex6 = this._B.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion2(double d, double d2) {
        Complex complex = this.getK(1);
        Complex complex2 = DoubleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = DoubleBarrierSolver.commonTerm2(complex, d);
        Complex complex4 = DoubleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = this._C.getMultiply(complex2).getMultiply(complex4);
        Complex complex6 = this._D.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion3(double d, double d2) {
        Complex complex = this.getK(2);
        Complex complex2 = DoubleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = DoubleBarrierSolver.commonTerm2(complex, d);
        Complex complex4 = DoubleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = this._F.getMultiply(complex2).getMultiply(complex4);
        Complex complex6 = this._G.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion4(double d, double d2) {
        Complex complex = this.getK(3);
        Complex complex2 = DoubleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = DoubleBarrierSolver.commonTerm2(complex, d);
        Complex complex4 = DoubleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = this._H.getMultiply(complex2).getMultiply(complex4);
        Complex complex6 = this._I.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion5(double d, double d2) {
        Complex complex = this.getK(4);
        Complex complex2 = DoubleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = DoubleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex4 = this._J.getMultiply(complex2).getMultiply(complex3);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex4);
        return waveFunctionSolution;
    }

    protected void updateCoefficients() {
        double d = this.getBoundary(0, 1);
        double d2 = this.getBoundary(1, 2);
        double d3 = this.getBoundary(2, 3);
        double d4 = this.getBoundary(3, 4);
        Complex complex = this.getK(0);
        Complex complex2 = this.getK(1);
        Complex complex3 = this.getK(2);
        Complex complex4 = this.getK(3);
        Complex complex5 = this.getK(4);
        Complex complex6 = DoubleBarrierSolver.getDenominator(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5);
        this.updateB(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateC(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateD(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateF(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateG(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateH(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateI(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
        this.updateJ(d, d2, d3, d4, complex, complex2, complex3, complex4, complex5, complex6);
    }

    private void updateB(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(2.0);
        mutableComplex.multiply(Complex.I);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(d);
        mutableComplex.exp();
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(complex2.getAdd(complex3));
        mutableComplex2.multiply(d2);
        mutableComplex2.add(complex4.getMultiply(d4));
        mutableComplex2.multiply(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex.getAdd(complex2));
        mutableComplex2.multiply(complex2.getSubtract(complex3));
        mutableComplex2.multiply(complex3.getSubtract(complex4));
        mutableComplex2.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(complex2.getMultiply(d));
        mutableComplex3.add(complex3.getMultiply(d2));
        mutableComplex3.add(complex4.getMultiply(d4));
        mutableComplex3.multiply(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex3.multiply(complex2.getAdd(complex3));
        mutableComplex3.multiply(complex3.getSubtract(complex4));
        mutableComplex3.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex4 = new MutableComplex();
        mutableComplex4.setValue(complex2.getMultiply(d));
        mutableComplex4.add(complex3.getMultiply(d3));
        mutableComplex4.add(complex4.getMultiply(d4));
        mutableComplex4.multiply(2.0);
        mutableComplex4.multiply(Complex.I);
        mutableComplex4.exp();
        mutableComplex4.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex4.multiply(complex2.getSubtract(complex3));
        mutableComplex4.multiply(complex3.getAdd(complex4));
        mutableComplex4.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex5 = new MutableComplex();
        mutableComplex5.setValue(complex2.getMultiply(d2));
        mutableComplex5.add(complex3.getMultiply(d3));
        mutableComplex5.add(complex4.getMultiply(d4));
        mutableComplex5.multiply(2.0);
        mutableComplex5.multiply(Complex.I);
        mutableComplex5.exp();
        mutableComplex5.multiply(complex.getAdd(complex2));
        mutableComplex5.multiply(complex2.getAdd(complex3));
        mutableComplex5.multiply(complex3.getAdd(complex4));
        mutableComplex5.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex6 = new MutableComplex();
        mutableComplex6.setValue(complex2.getMultiply(d));
        mutableComplex6.add(complex3.getAdd(complex4).getMultiply(d3));
        mutableComplex6.multiply(2.0);
        mutableComplex6.multiply(Complex.I);
        mutableComplex6.exp();
        mutableComplex6.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex6.multiply(complex2.getSubtract(complex3));
        mutableComplex6.multiply(complex3.getSubtract(complex4));
        mutableComplex6.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex7 = new MutableComplex();
        mutableComplex7.setValue(complex2.getMultiply(d2));
        mutableComplex7.add(complex3.getAdd(complex4).getMultiply(d3));
        mutableComplex7.multiply(2.0);
        mutableComplex7.multiply(Complex.I);
        mutableComplex7.exp();
        mutableComplex7.multiply(complex.getAdd(complex2));
        mutableComplex7.multiply(complex2.getAdd(complex3));
        mutableComplex7.multiply(complex3.getSubtract(complex4));
        mutableComplex7.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex8 = new MutableComplex();
        mutableComplex8.setValue(complex2.getAdd(complex3));
        mutableComplex8.multiply(d2);
        mutableComplex8.add(complex4.getMultiply(d3));
        mutableComplex8.multiply(2.0);
        mutableComplex8.multiply(Complex.I);
        mutableComplex8.exp();
        mutableComplex8.multiply(complex.getAdd(complex2));
        mutableComplex8.multiply(complex2.getSubtract(complex3));
        mutableComplex8.multiply(complex3.getAdd(complex4));
        mutableComplex8.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex9 = new MutableComplex();
        mutableComplex9.setValue(complex2.getMultiply(d));
        mutableComplex9.add(complex3.getMultiply(d2));
        mutableComplex9.add(complex4.getMultiply(d3));
        mutableComplex9.multiply(2.0);
        mutableComplex9.multiply(Complex.I);
        mutableComplex9.exp();
        mutableComplex9.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex9.multiply(complex2.getAdd(complex3));
        mutableComplex9.multiply(complex3.getAdd(complex4));
        mutableComplex9.multiply(complex4.getAdd(complex5));
        if (this._B == null) {
            this._B = new MutableComplex();
        }
        this._B.setValue(mutableComplex2);
        this._B.subtract(mutableComplex3);
        this._B.subtract(mutableComplex4);
        this._B.add(mutableComplex5);
        this._B.subtract(mutableComplex6);
        this._B.add(mutableComplex7);
        this._B.add(mutableComplex8);
        this._B.subtract(mutableComplex9);
        this._B.multiply(mutableComplex);
        this._B.divide(complex6);
    }

    private void updateC(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(Complex.I);
        mutableComplex.multiply(complex.getAdd(complex2));
        mutableComplex.multiply(d);
        mutableComplex.exp();
        mutableComplex.multiply(2.0);
        mutableComplex.multiply(complex);
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(complex3.getMultiply(d2));
        mutableComplex2.add(complex4.getMultiply(d4));
        mutableComplex2.multiply(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex2.getAdd(complex3));
        mutableComplex2.multiply(complex3.getSubtract(complex4));
        mutableComplex2.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(complex3.getMultiply(d3));
        mutableComplex3.add(complex4.getMultiply(d4));
        mutableComplex3.multiply(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex2.getMultiply(-1.0).getAdd(complex3));
        mutableComplex3.multiply(complex3.getAdd(complex4));
        mutableComplex3.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex4 = new MutableComplex();
        mutableComplex4.setValue(2.0);
        mutableComplex4.multiply(Complex.I);
        mutableComplex4.multiply(complex3.getAdd(complex4));
        mutableComplex4.multiply(d3);
        mutableComplex4.exp();
        mutableComplex4.multiply(complex2.getMultiply(-1.0).getAdd(complex3));
        mutableComplex4.multiply(complex3.getSubtract(complex4));
        mutableComplex4.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex5 = new MutableComplex();
        mutableComplex5.setValue(complex3.getMultiply(d2));
        mutableComplex5.add(complex4.getMultiply(d3));
        mutableComplex5.multiply(2.0);
        mutableComplex5.multiply(Complex.I);
        mutableComplex5.exp();
        mutableComplex5.multiply(complex2.getAdd(complex3));
        mutableComplex5.multiply(complex3.getAdd(complex4));
        mutableComplex5.multiply(complex4.getAdd(complex5));
        if (this._C == null) {
            this._C = new MutableComplex();
        }
        this._C.setValue(mutableComplex2);
        this._C.subtract(mutableComplex3);
        this._C.subtract(mutableComplex4);
        this._C.add(mutableComplex5);
        this._C.multiply(mutableComplex);
        this._C.divide(complex6);
    }

    private void updateD(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(complex.getAdd(complex2));
        mutableComplex.multiply(d);
        mutableComplex.add(complex2.getMultiply(2.0 * d2));
        mutableComplex.multiply(Complex.I);
        mutableComplex.exp();
        mutableComplex.multiply(2.0);
        mutableComplex.multiply(complex);
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(complex3.getMultiply(d2));
        mutableComplex2.add(complex4.getMultiply(d4));
        mutableComplex2.multiply(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex2.getMultiply(-1.0).getAdd(complex3));
        mutableComplex2.multiply(complex3.getSubtract(complex4));
        mutableComplex2.multiply(complex4.getSubtract(complex5));
        mutableComplex2.multiply(-1.0);
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(complex3.getMultiply(d3));
        mutableComplex3.add(complex4.getMultiply(d4));
        mutableComplex3.multiply(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex2.getAdd(complex3));
        mutableComplex3.multiply(complex3.getAdd(complex4));
        mutableComplex3.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex4 = new MutableComplex();
        mutableComplex4.setValue(2.0);
        mutableComplex4.multiply(Complex.I);
        mutableComplex4.multiply(complex3.getAdd(complex4));
        mutableComplex4.multiply(d3);
        mutableComplex4.exp();
        mutableComplex4.multiply(complex2.getAdd(complex3));
        mutableComplex4.multiply(complex3.getSubtract(complex4));
        mutableComplex4.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex5 = new MutableComplex();
        mutableComplex5.setValue(complex3.getMultiply(d2));
        mutableComplex5.add(complex4.getMultiply(d3));
        mutableComplex5.multiply(2.0);
        mutableComplex5.multiply(Complex.I);
        mutableComplex5.exp();
        mutableComplex5.multiply(complex2.getMultiply(-1.0).getAdd(complex3));
        mutableComplex5.multiply(complex3.getAdd(complex4));
        mutableComplex5.multiply(complex4.getAdd(complex5));
        if (this._D == null) {
            this._D = new MutableComplex();
        }
        this._D.setValue(mutableComplex2);
        this._D.add(mutableComplex3);
        this._D.add(mutableComplex4);
        this._D.subtract(mutableComplex5);
        this._D.multiply(mutableComplex);
        this._D.divide(complex6);
    }

    private void updateF(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(complex.getAdd(complex2).getMultiply(d));
        mutableComplex.add(complex2.getAdd(complex3).getMultiply(d2));
        mutableComplex.multiply(Complex.I);
        mutableComplex.exp();
        mutableComplex.multiply(4.0);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(complex2);
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.multiply(complex4);
        mutableComplex2.multiply(d4);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex3.getMultiply(-1.0).getAdd(complex4));
        mutableComplex2.multiply(complex4.getSubtract(complex5));
        mutableComplex2.multiply(-1.0);
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.multiply(complex4);
        mutableComplex3.multiply(d3);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex3.getAdd(complex4));
        mutableComplex3.multiply(complex4.getAdd(complex5));
        if (this._F == null) {
            this._F = new MutableComplex();
        }
        this._F.setValue(mutableComplex2);
        this._F.add(mutableComplex3);
        this._F.multiply(mutableComplex);
        this._F.divide(complex6);
    }

    private void updateG(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(complex.getMultiply(d));
        mutableComplex.add(complex2.getMultiply(d + d2));
        mutableComplex.add(complex3.getMultiply(d2 + 2.0 * d3));
        mutableComplex.multiply(Complex.I);
        mutableComplex.exp();
        mutableComplex.multiply(4.0);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(complex2);
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.multiply(complex4);
        mutableComplex2.multiply(d4);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex3.getAdd(complex4));
        mutableComplex2.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.multiply(complex4);
        mutableComplex3.multiply(d3);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex3.getMultiply(-1.0).getAdd(complex4));
        mutableComplex3.multiply(complex4.getAdd(complex5));
        if (this._G == null) {
            this._G = new MutableComplex();
        }
        this._G.setValue(mutableComplex2);
        this._G.subtract(mutableComplex3);
        this._G.multiply(mutableComplex);
        this._G.divide(complex6);
    }

    private void updateH(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        if (this._H == null) {
            this._H = new MutableComplex();
        }
        this._H.setValue(complex.getMultiply(d));
        this._H.add(complex3.getMultiply(d2));
        this._H.add(complex2.getMultiply(d + d2));
        this._H.add(complex3.getAdd(complex4).getMultiply(d3));
        this._H.multiply(Complex.I);
        this._H.exp();
        this._H.multiply(8.0);
        this._H.multiply(complex);
        this._H.multiply(complex2);
        this._H.multiply(complex3);
        this._H.multiply(complex4.getAdd(complex5));
        this._H.divide(complex6);
    }

    private void updateI(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        if (this._I == null) {
            this._I = new MutableComplex();
        }
        this._I.setValue(complex.getMultiply(d));
        this._I.add(complex3.getMultiply(d2));
        this._I.add(complex2.getMultiply(d + d2));
        this._I.add(complex3.getMultiply(d3));
        this._I.add(complex4.getMultiply(d3));
        this._I.add(complex4.getMultiply(2.0 * d4));
        this._I.multiply(Complex.I);
        this._I.exp();
        this._I.multiply(8.0);
        this._I.multiply(complex);
        this._I.multiply(complex2);
        this._I.multiply(complex3);
        this._I.multiply(complex4.getSubtract(complex5));
        this._I.divide(complex6);
    }

    private void updateJ(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6) {
        if (this._J == null) {
            this._J = new MutableComplex();
        }
        this._J.setValue(complex.getMultiply(d));
        this._J.add(complex3.getMultiply(d2));
        this._J.add(complex2.getMultiply(d + d2));
        this._J.add(complex3.getMultiply(d3));
        this._J.add(complex4.getMultiply(d3));
        this._J.add(complex4.getMultiply(d4));
        this._J.subtract(complex5.getMultiply(d4));
        this._J.multiply(Complex.I);
        this._J.exp();
        this._J.multiply(16.0);
        this._J.multiply(complex);
        this._J.multiply(complex2);
        this._J.multiply(complex3);
        this._J.multiply(complex4);
        this._J.divide(complex6);
    }

    private static Complex getDenominator(double d, double d2, double d3, double d4, Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(complex2.getAdd(complex3));
        mutableComplex.multiply(d2);
        mutableComplex.add(complex4.getMultiply(d4));
        mutableComplex.multiply(2.0);
        mutableComplex.multiply(Complex.I);
        mutableComplex.exp();
        mutableComplex.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex.multiply(complex2.getSubtract(complex3));
        mutableComplex.multiply(complex3.getSubtract(complex4));
        mutableComplex.multiply(complex4.getSubtract(complex5));
        mutableComplex.multiply(-1.0);
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(complex2.getMultiply(d));
        mutableComplex2.add(complex3.getMultiply(d2));
        mutableComplex2.add(complex4.getMultiply(d4));
        mutableComplex2.multiply(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex.getAdd(complex2));
        mutableComplex2.multiply(complex2.getAdd(complex3));
        mutableComplex2.multiply(complex3.getSubtract(complex4));
        mutableComplex2.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(complex2.getMultiply(d));
        mutableComplex3.add(complex3.getMultiply(d3));
        mutableComplex3.add(complex4.getMultiply(d4));
        mutableComplex3.multiply(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex.getAdd(complex2));
        mutableComplex3.multiply(complex2.getSubtract(complex3));
        mutableComplex3.multiply(complex3.getAdd(complex4));
        mutableComplex3.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex4 = new MutableComplex();
        mutableComplex4.setValue(complex2.getMultiply(d2));
        mutableComplex4.add(complex3.getMultiply(d3));
        mutableComplex4.add(complex4.getMultiply(d4));
        mutableComplex4.multiply(2.0);
        mutableComplex4.multiply(Complex.I);
        mutableComplex4.exp();
        mutableComplex4.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex4.multiply(complex2.getAdd(complex3));
        mutableComplex4.multiply(complex3.getAdd(complex4));
        mutableComplex4.multiply(complex4.getSubtract(complex5));
        MutableComplex mutableComplex5 = new MutableComplex();
        mutableComplex5.setValue(complex2.getMultiply(d));
        mutableComplex5.add(complex3.getAdd(complex4).getMultiply(d3));
        mutableComplex5.multiply(2.0);
        mutableComplex5.multiply(Complex.I);
        mutableComplex5.exp();
        mutableComplex5.multiply(complex.getAdd(complex2));
        mutableComplex5.multiply(complex2.getSubtract(complex3));
        mutableComplex5.multiply(complex3.getSubtract(complex4));
        mutableComplex5.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex6 = new MutableComplex();
        mutableComplex6.setValue(complex2.getMultiply(d2));
        mutableComplex6.add(complex3.getAdd(complex4).getMultiply(d3));
        mutableComplex6.multiply(2.0);
        mutableComplex6.multiply(Complex.I);
        mutableComplex6.exp();
        mutableComplex6.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex6.multiply(complex2.getAdd(complex3));
        mutableComplex6.multiply(complex3.getSubtract(complex4));
        mutableComplex6.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex7 = new MutableComplex();
        mutableComplex7.setValue(complex2.getAdd(complex3).getMultiply(d2));
        mutableComplex7.add(complex4.getMultiply(d3));
        mutableComplex7.multiply(2.0);
        mutableComplex7.multiply(Complex.I);
        mutableComplex7.exp();
        mutableComplex7.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex7.multiply(complex2.getSubtract(complex3));
        mutableComplex7.multiply(complex3.getAdd(complex4));
        mutableComplex7.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex8 = new MutableComplex();
        mutableComplex8.setValue(complex2.getMultiply(d));
        mutableComplex8.add(complex3.getMultiply(d2));
        mutableComplex8.add(complex4.getMultiply(d3));
        mutableComplex8.multiply(2.0);
        mutableComplex8.multiply(Complex.I);
        mutableComplex8.exp();
        mutableComplex8.multiply(complex.getAdd(complex2));
        mutableComplex8.multiply(complex2.getAdd(complex3));
        mutableComplex8.multiply(complex3.getAdd(complex4));
        mutableComplex8.multiply(complex4.getAdd(complex5));
        MutableComplex mutableComplex9 = new MutableComplex();
        mutableComplex9.setValue(mutableComplex);
        mutableComplex9.add(mutableComplex2);
        mutableComplex9.add(mutableComplex3);
        mutableComplex9.subtract(mutableComplex4);
        mutableComplex9.add(mutableComplex5);
        mutableComplex9.subtract(mutableComplex6);
        mutableComplex9.subtract(mutableComplex7);
        mutableComplex9.add(mutableComplex8);
        return mutableComplex9;
    }

    protected Complex getB() {
        if (this._B == null) {
            this.solve(0.0, 0.0);
        }
        return this._B;
    }
}

