/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SliderControl
extends JPanel
implements ChangeListener {
    private JSlider _slider;
    private JLabel _label;
    private double _min;
    private double _max;
    private double _tickSpacing;
    private double _multiplier;
    private DecimalFormat _tickNumberFormat;
    private DecimalFormat _labelNumberFormat;
    private String _labelFormat;
    private EventListenerList _listenerList;

    public SliderControl(double d, double d2, double d3, int n, int n2, String string, Insets insets) {
        if (d >= d2) {
            throw new IllegalArgumentException("min >= max");
        }
        if (d3 > d2 - d) {
            throw new IllegalArgumentException("tickSpacing > max - min");
        }
        if (n < 0) {
            throw new IllegalArgumentException("tickPrecision must be >= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("labelPrecision must be >= 0");
        }
        this._min = d;
        this._max = d2;
        this._tickSpacing = d3;
        this._multiplier = Math.pow(10.0, n2);
        this._tickNumberFormat = this.createFormat(n);
        this._labelNumberFormat = this.createFormat(n2);
        this._labelFormat = string;
        this._listenerList = new EventListenerList();
        this._label = new JLabel();
        this._slider = new JSlider();
        this._slider.setMinimum((int)(this._min * this._multiplier));
        this._slider.setMaximum((int)(this._max * this._multiplier));
        this._slider.setMajorTickSpacing((int)((this._max - this._min) * this._multiplier));
        this._slider.setMinorTickSpacing((int)(this._tickSpacing * this._multiplier));
        this._slider.setPaintTicks(true);
        this._slider.setPaintLabels(true);
        this.updateTickLabels();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        if (insets != null) {
            easyGridBagLayout.setInsets(insets);
        }
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.addAnchoredComponent(this._label, 0, 0, 17);
        easyGridBagLayout.addAnchoredComponent(this._slider, 1, 0, 17);
        this._slider.addChangeListener(this);
        this.updateLabel();
    }

    public void setValue(double d) {
        int n = 0;
        n = this.isInverted() ? (int)((this._max + this._min) * this._multiplier - d * this._multiplier) : (int)(d * this._multiplier);
        this._slider.setValue(n);
        this.updateLabel();
    }

    public double getValue() {
        int n = this.getSlider().getValue();
        double d = 0.0;
        if (this.isInverted()) {
            d = ((this._max + this._min) * this._multiplier - (double)n) / this._multiplier;
            if (d > this._max) {
                d = this._max;
            }
        } else {
            d = (double)n / this._multiplier;
        }
        return d;
    }

    public void setInverted(boolean bl) {
        if (this.isInverted() != bl) {
            this._slider.setInverted(bl);
            this.updateTickLabels();
        }
    }

    public boolean isInverted() {
        return this._slider.getInverted();
    }

    public JSlider getSlider() {
        return this._slider;
    }

    protected JLabel getLabel() {
        return this._label;
    }

    protected void updateLabel() {
        double d = this.getValue();
        String string = this._labelNumberFormat.format(d);
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(this._labelFormat, objectArray);
        this.getLabel().setText(string2);
    }

    private void updateTickLabels() {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (this.isInverted()) {
            hashtable.put(new Integer((int)(this._max * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._min)));
            hashtable.put(new Integer((int)(this._min * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._max)));
            double d = this._max - this._tickSpacing;
            double d2 = this._min + this._tickSpacing;
            while (d > this._min) {
                hashtable.put(new Integer((int)(d2 * this._multiplier)), new JLabel(this._tickNumberFormat.format(d)));
                d -= this._tickSpacing;
                d2 += this._tickSpacing;
            }
        } else {
            hashtable.put(new Integer((int)(this._max * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._max)));
            hashtable.put(new Integer((int)(this._min * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._min)));
            for (double d = this._min + this._tickSpacing; d < this._max; d += this._tickSpacing) {
                hashtable.put(new Integer((int)(d * this._multiplier)), new JLabel(this._tickNumberFormat.format(d)));
            }
        }
        this.getSlider().setLabelTable(hashtable);
    }

    private DecimalFormat createFormat(int n) {
        String string = "0";
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                string = string + ".";
            }
            string = string + "0";
        }
        return new DecimalFormat(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateLabel();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

