/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.color;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.module.QTModule;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class ColorSchemeDialog
extends PaintImmediateDialog
implements ColorChooserFactory.Listener {
    private static final Stroke COLOR_CHIP_STROKE = new BasicStroke(1.0f);
    private static final Color COLOR_CHIP_BORDER_COLOR = Color.BLACK;
    private Frame _parent;
    private QTModule _module;
    private QTColorScheme _scheme;
    private QTColorScheme _restoreScheme;
    private JLabel _currentChip;
    private JLabel _chartChip;
    private JLabel _ticksChip;
    private JLabel _gridlinesChip;
    private JLabel _annotationChip;
    private JLabel _regionMarkersChip;
    private JLabel _totalEnergyChip;
    private JLabel _potentialEnergyChip;
    private JLabel _realChip;
    private JLabel _imaginaryChip;
    private JLabel _magnitudeChip;
    private JLabel _probabilityDensityChip;
    private JButton _okButton;
    private JButton _cancelButton;
    private JDialog _colorChooserDialog;

    public ColorSchemeDialog(QTModule qTModule, QTColorScheme qTColorScheme) {
        super(PhetApplication.getInstance().getPhetFrame());
        super.setTitle(QTResources.getString("title.colorScheme"));
        super.setModal(false);
        super.setResizable(false);
        this._parent = PhetApplication.getInstance().getPhetFrame();
        this._module = qTModule;
        this._scheme = qTColorScheme;
        this._restoreScheme = new QTColorScheme(qTColorScheme);
        this.createUI();
        this.setLocationRelativeTo(this._parent);
    }

    private void createUI() {
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JSeparator(), "North");
        jPanel4.add((Component)jPanel2, "South");
        jPanel3.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
    }

    private JPanel createInputPanel() {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JLabel) {
                    ColorSchemeDialog.this.editColor((JLabel)mouseEvent.getSource());
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        JLabel jLabel = new JLabel(QTResources.getString("label.color.chart"));
        this._chartChip = new JLabel();
        this.setColor(this._chartChip, this._scheme.getChartColor());
        this._chartChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._chartChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.ticks"));
        this._ticksChip = new JLabel();
        this.setColor(this._ticksChip, this._scheme.getTickColor());
        this._ticksChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._ticksChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.gridlines"));
        this._gridlinesChip = new JLabel();
        this.setColor(this._gridlinesChip, this._scheme.getGridlineColor());
        this._gridlinesChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._gridlinesChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.annotations"));
        this._annotationChip = new JLabel();
        this.setColor(this._annotationChip, this._scheme.getAnnotationColor());
        this._annotationChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._annotationChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.regionMarkers"));
        this._regionMarkersChip = new JLabel();
        this.setColor(this._regionMarkersChip, this._scheme.getRegionMarkerColor());
        this._regionMarkersChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._regionMarkersChip, n, 1, 17);
        easyGridBagLayout.addComponent(this.createVerticalStrut(6), ++n, 0);
        jLabel = new JLabel(QTResources.getString("label.color.totalEnergy"));
        this._totalEnergyChip = new JLabel();
        this.setColor(this._totalEnergyChip, this._scheme.getTotalEnergyColor());
        this._totalEnergyChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._totalEnergyChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.potentialEnergy"));
        this._potentialEnergyChip = new JLabel();
        this.setColor(this._potentialEnergyChip, this._scheme.getPotentialEnergyColor());
        this._potentialEnergyChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._potentialEnergyChip, n, 1, 17);
        easyGridBagLayout.addComponent(this.createVerticalStrut(6), ++n, 0);
        jLabel = new JLabel(QTResources.getString("label.color.real"));
        this._realChip = new JLabel();
        this.setColor(this._realChip, this._scheme.getRealColor());
        this._realChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._realChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.imaginary"));
        this._imaginaryChip = new JLabel();
        this.setColor(this._imaginaryChip, this._scheme.getImaginaryColor());
        this._imaginaryChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._imaginaryChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.magnitude"));
        this._magnitudeChip = new JLabel();
        this.setColor(this._magnitudeChip, this._scheme.getMagnitudeColor());
        this._magnitudeChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._magnitudeChip, n, 1, 17);
        jLabel = new JLabel(QTResources.getString("label.color.probabilityDensity"));
        this._probabilityDensityChip = new JLabel();
        this.setColor(this._probabilityDensityChip, this._scheme.getProbabilityDensityColor());
        this._probabilityDensityChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._probabilityDensityChip, n, 1, 17);
        ++n;
        return jPanel;
    }

    private JPanel createActionsPanel() {
        this._okButton = new JButton(QTResources.getString("choice.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSchemeDialog.this.dispose();
            }
        });
        this._cancelButton = new JButton(QTResources.getString("choice.cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSchemeDialog.this.restoreColors();
                ColorSchemeDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JComponent createVerticalStrut(int n) {
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private void editColor(JLabel jLabel) {
        this._currentChip = jLabel;
        String string = null;
        Color color = null;
        if (this._currentChip == this._chartChip) {
            string = QTResources.getString("label.color.chart");
            color = this._scheme.getChartColor();
        } else if (this._currentChip == this._ticksChip) {
            string = QTResources.getString("label.color.ticks");
            color = this._scheme.getTickColor();
        } else if (this._currentChip == this._gridlinesChip) {
            string = QTResources.getString("label.color.gridlines");
            color = this._scheme.getGridlineColor();
        } else if (this._currentChip == this._annotationChip) {
            string = QTResources.getString("label.color.annotations");
            color = this._scheme.getAnnotationColor();
        } else if (this._currentChip == this._regionMarkersChip) {
            string = QTResources.getString("label.color.regionMarkers");
            color = this._scheme.getRegionMarkerColor();
        } else if (this._currentChip == this._totalEnergyChip) {
            string = QTResources.getString("label.color.totalEnergy");
            color = this._scheme.getTotalEnergyColor();
        } else if (this._currentChip == this._potentialEnergyChip) {
            string = QTResources.getString("label.color.potentialEnergy");
            color = this._scheme.getPotentialEnergyColor();
        } else if (this._currentChip == this._realChip) {
            string = QTResources.getString("label.color.real");
            color = this._scheme.getRealColor();
        } else if (this._currentChip == this._imaginaryChip) {
            string = QTResources.getString("label.color.imaginary");
            color = this._scheme.getImaginaryColor();
        } else if (this._currentChip == this._magnitudeChip) {
            string = QTResources.getString("label.color.magnitude");
            color = this._scheme.getMagnitudeColor();
        } else if (this._currentChip == this._probabilityDensityChip) {
            string = QTResources.getString("label.color.probabilityDensity");
            color = this._scheme.getProbabilityDensityColor();
        } else {
            throw new IllegalStateException("unsupported color scheme property");
        }
        String string2 = string + " " + QTResources.getString("title.chooseColor");
        this.closeColorChooser();
        this._colorChooserDialog = ColorChooserFactory.createDialog(string2, this._parent, color, this);
        this._colorChooserDialog.show();
    }

    private void restoreColors() {
        this._module.setColorScheme(this._restoreScheme);
        this._scheme = new QTColorScheme(this._restoreScheme);
    }

    private void closeColorChooser() {
        if (this._colorChooserDialog != null) {
            this._colorChooserDialog.dispose();
        }
    }

    private void setColor(JLabel jLabel, Color color) {
        Rectangle rectangle = new Rectangle(0, 0, 30, 30);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(rectangle);
        graphics2D.setStroke(COLOR_CHIP_STROKE);
        graphics2D.setColor(COLOR_CHIP_BORDER_COLOR);
        graphics2D.draw(rectangle);
        jLabel.setIcon(new ImageIcon(bufferedImage));
    }

    public void dispose() {
        this.closeColorChooser();
        super.dispose();
    }

    public void colorChanged(Color color) {
        this.handleColorChange(color);
    }

    public void ok(Color color) {
        this.handleColorChange(color);
    }

    public void cancelled(Color color) {
        this.handleColorChange(color);
    }

    private void handleColorChange(Color color) {
        this.setColor(this._currentChip, color);
        if (this._currentChip == this._chartChip) {
            this._scheme.setChartColor(color);
        } else if (this._currentChip == this._ticksChip) {
            this._scheme.setTickColor(color);
        } else if (this._currentChip == this._gridlinesChip) {
            this._scheme.setGridlineColor(color);
        } else if (this._currentChip == this._annotationChip) {
            this._scheme.setAnnotationColor(color);
        } else if (this._currentChip == this._regionMarkersChip) {
            this._scheme.setRegionMarkerColor(color);
        } else if (this._currentChip == this._totalEnergyChip) {
            this._scheme.setTotalEnergyColor(color);
        } else if (this._currentChip == this._potentialEnergyChip) {
            this._scheme.setPotentialEnergyColor(color);
        } else if (this._currentChip == this._realChip) {
            this._scheme.setRealColor(color);
        } else if (this._currentChip == this._imaginaryChip) {
            this._scheme.setImaginaryColor(color);
        } else if (this._currentChip == this._magnitudeChip) {
            this._scheme.setMagnitudeColor(color);
        } else if (this._currentChip == this._probabilityDensityChip) {
            this._scheme.setProbabilityDensityColor(color);
        } else {
            throw new IllegalStateException("unsupported color scheme property");
        }
        this._module.setColorScheme(this._scheme);
    }
}

