/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo;

import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;

public class XYPlotNode
extends PPath
implements PlotChangeListener {
    private XYPlot _plot;
    private Rectangle2D _dataArea;
    private boolean _dataAreaStroked;
    private String _name;
    private RenderingHints _renderingHints;

    public XYPlotNode(XYPlot xYPlot) {
        this._plot = xYPlot;
        this._plot.addChangeListener(this);
        this._dataArea = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this._dataAreaStroked = true;
        this._name = null;
        this._renderingHints = null;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this._renderingHints = renderingHints;
    }

    public void setDataArea(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D);
        this._dataArea.setRect(rectangle2D);
        this.repaint();
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.repaint();
    }

    protected void paint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this._renderingHints != null) {
            graphics2D.setRenderingHints(this._renderingHints);
        }
        pPaintContext.pushClip(this._dataArea);
        int n = this._plot.getDatasetCount();
        DatasetRenderingOrder datasetRenderingOrder = this._plot.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.FORWARD) {
            for (int i = 0; i < n; ++i) {
                this._plot.render(graphics2D, this._dataArea, i, null, null);
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                this._plot.render(graphics2D, this._dataArea, i, null, null);
            }
        }
        pPaintContext.popClip(null);
        if (this._dataAreaStroked) {
            graphics2D.setStroke(this._plot.getOutlineStroke());
            graphics2D.setPaint(this._plot.getOutlinePaint());
            graphics2D.draw(this._dataArea);
        }
    }
}

