/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.controller;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.dischargelamps.model.DischargeLampElementProperties;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.model.MetalEnergyAbsorptionStrategy;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import edu.colorado.phet.photoelectric.model.PhotoelectricTarget;
import edu.colorado.phet.photoelectric.model.SimpleEnergyAbsorptionStrategy;
import edu.colorado.phet.photoelectric.module.PhotoelectricModule;
import edu.colorado.phet.photoelectric.view.CompositeGraphPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PhotoelectricControlPanel {
    private Collection targetMaterials;

    public PhotoelectricControlPanel(PhotoelectricModule photoelectricModule) {
        Object object2;
        PhotoelectricModel photoelectricModel = (PhotoelectricModel)photoelectricModule.getModel();
        ControlPanel controlPanel = photoelectricModule.getControlPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(PhotoelectricResources.getString("Target")));
        controlPanel.addFullWidth(jPanel);
        Cloneable cloneable = new ArrayList<DischargeLampElementProperties>();
        cloneable.add(PhotoelectricTarget.SODIUM);
        this.targetMaterials = PhotoelectricTarget.TARGET_MATERIALS;
        for (Object object2 : this.targetMaterials) {
            if (object2 == PhotoelectricTarget.SODIUM || object2 == PhotoelectricTarget.MAGNESIUM) continue;
            cloneable.add((DischargeLampElementProperties)object2);
        }
        cloneable.add(PhotoelectricTarget.MAGNESIUM);
        Object object3 = new JComboBox<Object>(cloneable.toArray());
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).anchor = 10;
        jPanel.add((Component)object3, object2);
        final PhotoelectricTarget photoelectricTarget = photoelectricModel.getTarget();
        ((JComboBox)object3).addActionListener(new ActionListener((JComboBox)object3){
            final /* synthetic */ JComboBox val$targetMaterial;
            {
                this.val$targetMaterial = jComboBox;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                photoelectricTarget.setTargetMaterial((DischargeLampElementProperties)this.val$targetMaterial.getSelectedItem());
            }
        });
        photoelectricTarget.setTargetMaterial((DischargeLampElementProperties)((JComboBox)object3).getSelectedItem());
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        cloneable = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        object3 = new JCheckBox(PhotoelectricResources.getString("ControlPanel.SimpleMode"));
        ((AbstractButton)object3).addActionListener(new ActionListener((JCheckBox)object3){
            final /* synthetic */ JCheckBox val$electronModelCB;
            {
                this.val$electronModelCB = jCheckBox;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.val$electronModelCB.isSelected()) {
                    PhotoelectricControlPanel.this.setElectronModel(1);
                } else {
                    PhotoelectricControlPanel.this.setElectronModel(2);
                }
            }
        });
        jPanel.add((Component)object3, cloneable);
        controlPanel.addFullWidth(jPanel);
        controlPanel.addControlFullWidth(new CompositeGraphPanel(photoelectricModule));
    }

    private void setElectronModel(int n) {
        MetalEnergyAbsorptionStrategy metalEnergyAbsorptionStrategy = null;
        switch (n) {
            case 1: {
                for (DischargeLampElementProperties dischargeLampElementProperties : this.targetMaterials) {
                    metalEnergyAbsorptionStrategy = new SimpleEnergyAbsorptionStrategy(dischargeLampElementProperties.getWorkFunction());
                    dischargeLampElementProperties.setEnergyAbsorptionStrategy(metalEnergyAbsorptionStrategy);
                }
                break;
            }
            case 2: {
                for (DischargeLampElementProperties dischargeLampElementProperties : this.targetMaterials) {
                    metalEnergyAbsorptionStrategy = new MetalEnergyAbsorptionStrategy(dischargeLampElementProperties.getWorkFunction());
                    dischargeLampElementProperties.setEnergyAbsorptionStrategy(metalEnergyAbsorptionStrategy);
                }
                break;
            }
            default: {
                throw new RuntimeException("invalid parameter");
            }
        }
    }
}

