/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.WaveGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class TravelingWaveGraphic
extends WaveGraphic {
    public TravelingWaveGraphic(Component component, Point2D point2D, double d, double d2, double d3, double d4, Color color, LaserModel laserModel) {
        super(component, point2D, d, d2, d3, d4, color, laserModel.getResonatingCavity());
        laserModel.addModelElement(this);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        GeneralPath generalPath = this.getWavePath();
        generalPath.reset();
        for (int i = 0; i < this.getNumPts(); ++i) {
            double d2 = this.getDx() * (double)i;
            double d3 = this.getAmplitude() * Math.sin((d2 - this.getElapsedTime()) / this.getLambda() * Math.PI);
            Point2D point2D = this.getOrigin();
            if (i == 0) {
                generalPath.moveTo((float)(d2 + point2D.getX()), (float)(d3 + point2D.getY()));
                continue;
            }
            generalPath.lineTo((float)(d2 + point2D.getX()), (float)(d3 + point2D.getY()));
        }
        this.update();
    }
}

