/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.phslider;

import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PHTextFieldNode
extends PNode {
    private static final Font LABEL_FONT = new PhetFont(1, 18);
    private static final Font VALUE_FONT = new PhetFont(18);
    private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("#0.00");
    private double _pH;
    private final IntegerRange _range;
    private final JFormattedTextField _textField;
    private final ArrayList _listeners;

    public PHTextFieldNode(IntegerRange integerRange) {
        this._range = new IntegerRange(integerRange);
        this._listeners = new ArrayList();
        EventHandler eventHandler = new EventHandler();
        JLabel jLabel = new JLabel(PHScaleStrings.LABEL_PH);
        jLabel.setFont(LABEL_FONT);
        this._textField = new JFormattedTextField((Object)"XX.XX");
        this._textField.setFont(VALUE_FONT);
        this._textField.setColumns(4);
        this._textField.setHorizontalAlignment(4);
        this._textField.addActionListener(eventHandler);
        this._textField.addFocusListener(eventHandler);
        this._textField.addKeyListener(eventHandler);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.addComponent(jLabel, 0, 0);
        easyGridBagLayout.addComponent(this._textField, 0, 1);
        PSwing pSwing = new PSwing(jPanel);
        this.addChild(pSwing);
        this.setPH(integerRange.getDefault());
    }

    public double getPH() {
        return this._pH;
    }

    public void setPH(double d) {
        if (!this._range.contains(d)) {
            throw new IllegalArgumentException("pH is out of range: " + d);
        }
        if (d != this._pH) {
            this._pH = d;
            this.setTextField(d);
            this.notifyChanged();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this._textField.isEnabled()) {
            this._textField.setEnabled(bl);
            if (bl) {
                this.setTextField(this._pH);
            } else {
                this._textField.setText("");
            }
        }
    }

    private void setTextField(double d) {
        assert (this._range.contains(d));
        if (this._textField.isEnabled()) {
            this._textField.setText(VALUE_FORMAT.format(d));
        }
    }

    private void handleTextFieldChanged() {
        String string = this._textField.getText();
        try {
            double d = Double.parseDouble(string);
            if (this._range.contains(d)) {
                this.setPH(d);
            } else {
                this.revert();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.revert();
        }
    }

    private void revert() {
        Toolkit.getDefaultToolkit().beep();
        this.setTextField(this._pH);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listeners.add(changeListener);
    }

    private void notifyChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private class EventHandler
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private EventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == PHTextFieldNode.this._textField) {
                if (keyEvent.getKeyCode() == 38) {
                    double d = PHTextFieldNode.this._pH + 0.01;
                    if (PHTextFieldNode.this._range.contains(d)) {
                        PHTextFieldNode.this.setPH(d);
                    }
                } else if (keyEvent.getKeyCode() == 40) {
                    double d = PHTextFieldNode.this._pH - 0.01;
                    if (PHTextFieldNode.this._range.contains(d)) {
                        PHTextFieldNode.this.setPH(d);
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PHTextFieldNode.this._textField) {
                PHTextFieldNode.this.handleTextFieldChanged();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PHTextFieldNode.this._textField) {
                // empty if block
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PHTextFieldNode.this._textField) {
                try {
                    PHTextFieldNode.this._textField.commitEdit();
                    PHTextFieldNode.this.handleTextFieldChanged();
                }
                catch (ParseException parseException) {
                    PHTextFieldNode.this.revert();
                }
            }
        }
    }
}

