/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.phslider;

import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PHSliderNode
extends PNode {
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final Color TRACK_COLOR = Color.BLACK;
    private static final Color ACID_COLOR = PHScaleConstants.H3O_COLOR;
    private static final Color BASE_COLOR = PHScaleConstants.OH_COLOR;
    private static final Stroke KNOB_STROKE = new BasicStroke(1.0f);
    private static final Color KNOB_FILL_COLOR = new Color(255, 255, 255, 200);
    private static final Color KNOB_STROKE_COLOR = Color.BLACK;
    private static final Font TICK_FONT = new PhetFont(16);
    private static final Stroke TICK_STROKE = new BasicStroke(1.0f);
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Font ACID_BASE_FONT = new PhetFont(16);
    private final IntegerRange _range;
    private final TrackNode _trackNode;
    private final KnobNode _knobNode;
    private PComposite _ticksNode;
    private final ArrayList _listeners;
    private double _pH;

    public PHSliderNode(IntegerRange integerRange, double d, double d2, PDimension pDimension) {
        this._range = new IntegerRange(integerRange);
        this._listeners = new ArrayList();
        PDimension pDimension2 = new PDimension(d, (double)integerRange.getLength() * d2);
        this._trackNode = new TrackNode(pDimension2);
        this._knobNode = new KnobNode(pDimension);
        this._ticksNode = new PComposite();
        TickMarkNode tickMarkNode = null;
        double d3 = 0.0;
        double d4 = pDimension2.getHeight() / (double)this._range.getLength();
        for (int i = this._range.getMax(); i >= this._range.getMin(); --i) {
            tickMarkNode = i % 2 == 0 ? new TickMarkNode(String.valueOf(i)) : new TickMarkNode();
            this._ticksNode.addChild(tickMarkNode);
            tickMarkNode.setOffset(0.0, d3);
            d3 += d4;
        }
        PText pText = new PText(PHScaleStrings.LABEL_ACID);
        pText.setFont(ACID_BASE_FONT);
        pText.rotate(-1.5707963267948966);
        PText pText2 = new PText(PHScaleStrings.LABEL_BASE);
        pText2.setFont(ACID_BASE_FONT);
        pText2.rotate(-1.5707963267948966);
        this.addChild(this._trackNode);
        this.addChild(pText);
        this.addChild(pText2);
        this.addChild(this._ticksNode);
        this.addChild(this._knobNode);
        this._trackNode.setOffset(0.0, 0.0);
        this._ticksNode.setOffset(this._trackNode.getFullBoundsReference().getMaxX() + 3.0, this._trackNode.getYOffset());
        this._knobNode.setOffset(this._trackNode.getFullBoundsReference().getMaxX() + 0.25 * this._knobNode.getFullBoundsReference().getWidth(), 0.0);
        pText.setOffset(-(pText.getFullBoundsReference().getWidth() + 4.0), this._trackNode.getFullBoundsReference().getHeight() - 5.0);
        pText2.setOffset(-(pText2.getFullBoundsReference().getWidth() + 4.0), pText2.getFullBoundsReference().getHeight() + 5.0);
        this.initInteractivity();
        this.setPH(this._range.getDefault());
    }

    private void initInteractivity() {
        this._knobNode.addInputEventListener(new CursorHandler());
        this._knobNode.addInputEventListener(new PDragEventHandler(){
            private double _globalClickYOffset;

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                Point2D point2D = pInputEvent.getPositionRelativeTo(PHSliderNode.this);
                Point2D point2D2 = PHSliderNode.this.localToGlobal(point2D);
                Point2D point2D3 = PHSliderNode.this.localToGlobal(PHSliderNode.this._knobNode.getOffset());
                this._globalClickYOffset = point2D2.getY() - point2D3.getY();
            }

            protected void drag(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getPositionRelativeTo(PHSliderNode.this);
                Point2D point2D2 = PHSliderNode.this.localToGlobal(point2D);
                Point2D.Double double_ = new Point2D.Double(point2D2.getX(), point2D2.getY() - this._globalClickYOffset);
                Point2D point2D3 = PHSliderNode.this.globalToLocal(double_);
                double d = point2D3.getY();
                double d2 = PHSliderNode.this._trackNode.getFullBoundsReference().getHeight();
                double d3 = 0.0;
                d3 = (double)PHSliderNode.this._range.getMin() + (double)PHSliderNode.this._range.getLength() * (d2 - d) / d2;
                if (d3 < (double)PHSliderNode.this._range.getMin()) {
                    d3 = PHSliderNode.this._range.getMin();
                } else if (d3 > (double)PHSliderNode.this._range.getMax()) {
                    d3 = PHSliderNode.this._range.getMax();
                }
                PHSliderNode.this.setPH(d3);
            }
        });
    }

    public double getPH() {
        return this._pH;
    }

    public void setPH(double d) {
        if (!this._range.contains(d)) {
            throw new IllegalArgumentException("pH is out of range: " + d);
        }
        if (d != this._pH) {
            this._pH = d;
            double d2 = this._knobNode.getXOffset();
            double d3 = this._trackNode.getFullBoundsReference().getHeight() * (((double)this._range.getMax() - d) / (double)this._range.getLength());
            this._knobNode.setOffset(d2, d3);
            this.notifyChanged();
        }
    }

    public void setEnabled(boolean bl) {
        this.setKnobVisible(bl);
    }

    private void setKnobVisible(boolean bl) {
        this._knobNode.setVisible(bl);
    }

    public Point2D getTickAlignmentGlobalOffset() {
        return this.localToGlobal(new Point2D.Double(0.0, this._ticksNode.getYOffset()));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listeners.add(changeListener);
    }

    private void notifyChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private static class KnobNode
    extends PNode {
        public KnobNode(PDimension pDimension) {
            float f = (float)pDimension.getWidth();
            float f2 = (float)pDimension.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(-0.35f * f, f2 / 2.0f);
            generalPath.lineTo(-f, f2 / 2.0f);
            generalPath.lineTo(-f, -f2 / 2.0f);
            generalPath.lineTo(-0.35f * f, -f2 / 2.0f);
            generalPath.closePath();
            PPath pPath = new PPath();
            pPath.setPathTo(generalPath);
            pPath.setPaint(KNOB_FILL_COLOR);
            pPath.setStroke(KNOB_STROKE);
            pPath.setStrokePaint(KNOB_STROKE_COLOR);
            this.addChild(pPath);
        }
    }

    private static class TickMarkNode
    extends PComposite {
        public TickMarkNode() {
            this(null);
        }

        public TickMarkNode(String string) {
            this.setPickable(false);
            this.setChildrenPickable(false);
            PPath pPath = new PPath(new Line2D.Double(0.0, 0.0, 10.0, 0.0));
            pPath.setStroke(TICK_STROKE);
            pPath.setStrokePaint(TICK_COLOR);
            this.addChild(pPath);
            PText pText = null;
            if (string != null) {
                pText = new PText(string);
                pText.setFont(TICK_FONT);
                pText.setOffset(pPath.getFullBoundsReference().getMaxX() + 2.0, -pText.getFullBoundsReference().getHeight() / 2.0);
                this.addChild(pText);
            }
        }
    }

    private static class TrackNode
    extends PNode {
        public TrackNode(PDimension pDimension) {
            this.setPickable(false);
            this.setChildrenPickable(false);
            PPath pPath = new PPath();
            double d = pDimension.getWidth() - 1.0;
            double d2 = pDimension.getHeight() - 1.0;
            pPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
            GradientPaint gradientPaint = null;
            gradientPaint = new GradientPaint(0.0f, 0.0f, BASE_COLOR, 0.0f, (float)pDimension.getHeight(), ACID_COLOR);
            pPath.setPaint(gradientPaint);
            pPath.setStroke(TRACK_STROKE);
            pPath.setStrokePaint(TRACK_COLOR);
            this.addChild(pPath);
        }
    }
}

