/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.phslider;

import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.PHValue;
import edu.colorado.phet.phscale.view.phslider.PHSliderNode;
import edu.colorado.phet.phscale.view.phslider.PHTextFieldNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PHControlNode
extends PNode {
    private static final PDimension KNOB_SIZE = new PDimension(40.0, 30.0);
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final PHTextFieldNode _textFieldNode;
    private final PHSliderNode _sliderNode;
    private boolean _notifyEnabled = false;

    public PHControlNode(Liquid liquid, double d) {
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                PHControlNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        this._textFieldNode = new PHTextFieldNode(liquid.getPHRange());
        this._sliderNode = new PHSliderNode(liquid.getPHRange(), 10.0, d, KNOB_SIZE);
        PNode pNode = new PNode();
        pNode.addChild(this._textFieldNode);
        pNode.addChild(this._sliderNode);
        this._textFieldNode.setOffset(0.0, 0.0);
        PBounds pBounds = this._textFieldNode.getFullBoundsReference();
        this._sliderNode.setOffset(pBounds.getWidth() / 2.0 - 5.0, pBounds.getHeight() + KNOB_SIZE.getWidth() / 2.0 + 10.0);
        double d2 = pNode.getFullBoundsReference().getWidth() + 30.0;
        double d3 = pNode.getFullBoundsReference().getHeight() + 30.0 + KNOB_SIZE.getWidth() / 2.0;
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, d2, d3));
        pPath.setStroke(new BasicStroke(2.0f));
        pPath.setStrokePaint(Color.BLACK);
        this.addChild(pNode);
        this.addChild(pPath);
        pPath.setOffset(0.0, 0.0);
        PBounds pBounds2 = pPath.getFullBoundsReference();
        PBounds pBounds3 = pNode.getFullBoundsReference();
        pNode.setOffset((pBounds2.getWidth() - pBounds3.getWidth()) / 2.0, 15.0);
        this._textFieldNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PHControlNode.this.updateModelPH(PHControlNode.this._textFieldNode.getPH());
            }
        });
        this._sliderNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PHControlNode.this.updateModelPH(PHControlNode.this._sliderNode.getPH());
            }
        });
        this.update();
    }

    public Point2D getTickAlignmentGlobalOffset() {
        return this._sliderNode.getTickAlignmentGlobalOffset();
    }

    private void updateModelPH(double d) {
        if (this._notifyEnabled) {
            this._liquid.setPH(d);
        }
    }

    private void update() {
        this._notifyEnabled = false;
        PHValue pHValue = this._liquid.getPH();
        if (pHValue != null) {
            this._sliderNode.setEnabled(true);
            this._textFieldNode.setEnabled(true);
            this._sliderNode.setPH(pHValue.getValue());
            this._textFieldNode.setPH(pHValue.getValue());
        } else {
            this._sliderNode.setEnabled(false);
            this._textFieldNode.setEnabled(false);
        }
        this._notifyEnabled = true;
    }
}

