/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.phscale.PHScaleStrings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ZoomControlPanel
extends JPanel {
    private final ArrayList _listeners = new ArrayList();
    private final JButton _zoomInButton = new JButton(PHScaleStrings.BUTTON_ZOOM_IN);
    private final JButton _zoomOutButton;

    public ZoomControlPanel() {
        this._zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomControlPanel.this.notifyZoomIn();
            }
        });
        this._zoomOutButton = new JButton(PHScaleStrings.BUTTON_ZOOM_OUT);
        this._zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomControlPanel.this.notifyZoomOut();
            }
        });
        this.setOpaque(false);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addFilledComponent(this._zoomInButton, n++, n2, 2);
        easyGridBagLayout.addFilledComponent(this._zoomOutButton, n++, n2, 2);
    }

    public void setZoomInEnabled(boolean bl) {
        this._zoomInButton.setEnabled(bl);
    }

    public void setZoomOutEnabled(boolean bl) {
        this._zoomOutButton.setEnabled(bl);
    }

    public void addZoomControlPanelListener(ZoomControlPanelListener zoomControlPanelListener) {
        this._listeners.add(zoomControlPanelListener);
    }

    private void notifyZoomIn() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ZoomControlPanelListener)iterator.next()).zoomIn();
        }
    }

    private void notifyZoomOut() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ZoomControlPanelListener)iterator.next()).zoomOut();
        }
    }

    public static interface ZoomControlPanelListener {
        public void zoomIn();

        public void zoomOut();
    }
}

