/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UnitsControlPanel
extends JPanel {
    private static final Font CONTROL_FONT = PHScaleConstants.CONTROL_FONT;
    private final ArrayList _listeners;
    private final JRadioButton _concentrationRadioButton;
    private final JRadioButton _molesRadioButton;

    public UnitsControlPanel() {
        this.setOpaque(false);
        this._listeners = new ArrayList();
        this._concentrationRadioButton = new JRadioButton(PHScaleStrings.getConcentrationString());
        this._concentrationRadioButton.setOpaque(false);
        this._concentrationRadioButton.setFont(CONTROL_FONT);
        this._concentrationRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnitsControlPanel.this.notifySelectionChanged();
            }
        });
        this._molesRadioButton = new JRadioButton(PHScaleStrings.getNumberOfMolesString());
        this._molesRadioButton.setOpaque(false);
        this._molesRadioButton.setFont(CONTROL_FONT);
        this._molesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnitsControlPanel.this.notifySelectionChanged();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._concentrationRadioButton);
        buttonGroup.add(this._molesRadioButton);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._concentrationRadioButton, n++, n2);
        easyGridBagLayout.addComponent(this._molesRadioButton, n++, n2);
        this._concentrationRadioButton.setSelected(true);
    }

    public boolean isConcentrationSelected() {
        return this._concentrationRadioButton.isSelected();
    }

    public void setConcentrationSelected(boolean bl) {
        if (bl != this.isConcentrationSelected()) {
            this._concentrationRadioButton.setSelected(bl);
            this.notifySelectionChanged();
        }
    }

    public void addUnitsControlPanelListener(UnitsControlPanelListener unitsControlPanelListener) {
        this._listeners.add(unitsControlPanelListener);
    }

    private void notifySelectionChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((UnitsControlPanelListener)iterator.next()).selectionChanged();
        }
    }

    public static interface UnitsControlPanelListener {
        public void selectionChanged();
    }
}

