/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ScaleControlPanel
extends JPanel {
    private static final Font CONTROL_FONT = PHScaleConstants.CONTROL_FONT;
    private final ArrayList _listeners;
    private final JRadioButton _logRadioButton;
    private final JRadioButton _linearRadioButton;

    public ScaleControlPanel() {
        this.setOpaque(false);
        this._listeners = new ArrayList();
        this._logRadioButton = new JRadioButton(PHScaleStrings.RADIO_BUTTON_LOGARITHMIC_SCALE);
        this._logRadioButton.setOpaque(false);
        this._logRadioButton.setFont(CONTROL_FONT);
        this._logRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScaleControlPanel.this.notifySelectionChanged();
            }
        });
        this._linearRadioButton = new JRadioButton(PHScaleStrings.RADIO_BUTTON_LINEAR_SCALE);
        this._linearRadioButton.setOpaque(false);
        this._linearRadioButton.setFont(CONTROL_FONT);
        this._linearRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScaleControlPanel.this.notifySelectionChanged();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._logRadioButton);
        buttonGroup.add(this._linearRadioButton);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._logRadioButton, n++, n2);
        easyGridBagLayout.addComponent(this._linearRadioButton, n++, n2);
        this._logRadioButton.setSelected(true);
    }

    public boolean isLogSelected() {
        return this._logRadioButton.isSelected();
    }

    public void setLogSelected(boolean bl) {
        if (bl != this.isLogSelected()) {
            this._logRadioButton.setSelected(bl);
            this.notifySelectionChanged();
        }
    }

    public void addScaleControlPanelListener(ScaleControlPanelListener scaleControlPanelListener) {
        this._listeners.add(scaleControlPanelListener);
    }

    private void notifySelectionChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ScaleControlPanelListener)iterator.next()).selectionChanged();
        }
    }

    public static interface ScaleControlPanelListener {
        public void selectionChanged();
    }
}

